<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidatorRequires.php,v 1.8 2007/01/21 08:14:45 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ɬܸڥ饹checkbox, selectѡ
 * 
 * 
 * $SyL_Validator =& SyL_Validator::create( 'require', '{name}ɬܤǤ' );
 *
 * 顼åѴʸ
 *  ʤ
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidatorRequires.php,v 1.8 2007/01/21 08:14:45 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ValidatorRequires extends SyL_Validator
{
    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param string 顼åΥեޥå
     * @param array ڥѥ᡼
     */
    function SyL_ValidatorRequires($error_message, $parameters=array())
    {
        // ǥեȥѥ᡼
        $init_parameters = array(
          'min'       => 1, // checkbox, selectκǾå
          'min_error' => null,
          'max'       => null, // checkbox, selectκå
          'max_error' => null
        );
        $parameters = array_merge($init_parameters, $parameters);
        parent::SyL_Validator($error_message, $parameters);
    }

    /**
     * ɬܸڽ¹Ԥ
     *
     * @access public
     * @param array о
     * @return bool true: 顼̵, false: 顼
     */
    function validate($value)
    {
        $cnt = count($value);
        if ($this->parameters['min'] !== null) {
            if ($cnt < $this->parameters['min']) {
                if ($this->parameters['min_error'] !== null) {
                    $this->error_message = $this->parameters['min_error'];
                }
                return false;
            }
        }

        if ($this->parameters['max'] !== null) {
            if ($cnt > $this->parameters['max']) {
                if ($this->parameters['max_error'] !== null) {
                    $this->error_message = $this->parameters['max_error'];
                }
                return false;
            }
        }
        return true;
    }

    /**
     * 顼å
     * С饤
     *
     * @access public
     * @param string ̾
     * @return string 顼å
     */
    function getErrorMessage($name='')
    {
        if ($this->parameters['min'] !== null) {
            $this->error_message = str_replace('{min}', $this->parameters['min'], $this->error_message);
        }
        if ($this->parameters['max'] !== null) {
            $this->error_message = str_replace('{max}', $this->parameters['max'], $this->error_message);
        }
        return parent::getErrorMessage($name);
    }

    /**
     * ɬܸڽJavaScript
     *
     * @access public
     * @param string եɽ̾
     * @param array եǤradio, select, checkboxξΤߡ
     * @return string JavaScriptå
     */
    function getJavaScript($display_name, $parts)
    {
        $min       = $this->parameters['min'];
        $min_error = $this->parameters['min_error'];
        if ($min && $min_error) {
            $min_error = str_replace('{min}', $this->parameters['min'], $min_error);
        }
        $max = $this->parameters['max'];
        $max_error = $this->parameters['max_error'];
        if ($max && $max_error) {
            $max_error = str_replace('{max}', $this->parameters['max'], $max_error);
        }

        $js  = '';
        $js .= 'if (!error_flag && !validator.isRequires(element_name, "' . $this->getErrorMessage($display_name) . '", "' . $min . '", "' . $min_error . '", "' . $max . '", "' . $max_error . '")) {' . "\r\n";
        $js .= '  error_flag = true;' . "\r\n";
        $js .= '}' . "\r\n";
        return $js;
    }

}

?>
