<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRssReader2_0.php,v 1.1 2007/03/17 13:53:07 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * RSS 0.91꡼饹
 */
require_once 'SyL_XmlRssReader0_91.php';

/**
 * RSS 2.0꡼饹
 *
 * С̡ݲ
 *
 * [channel]
 *   copyright
 *   description
 *   language
 *   link
 *   date     <- pubDate
 *   title
 *   category
 *
 * [image]
 *   height
 *   link
 *   title
 *   url
 *   width
 *
 * [textInput]
 *   description
 *   link
 *   name
 *   title
 *
 * [item]
 *   description
 *   link
 *   title
 *   author
 *   category
 *   date    <- pubDate
 *   source
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRssReader2_0.php,v 1.1 2007/03/17 13:53:07 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_XmlRssReader2_0 extends SyL_XmlRssReader0_91
{
    /**
     * RSSС
     * 
     * @access protected
     * @var string
     */
    var $version = '2.0';

    /**
     * XMLǡƼϥɥ᥽å
     * С饤
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        // XMLϷ̤
        switch ($current_path) {
        // -------------------------------------------------
        // إå
        // -------------------------------------------------
        case '/rss/channel/generator': $this->channel['generator'] = $text; break; // RSSƥ
        case '/rss/channel/cloud':     $this->channel['cloud']     = $attribute; break;
        case '/rss/channel/ttl':       $this->channel['ttl']       = $text; break; // RSSåʬ

        // -------------------------------------------------
        // ǡ
        // -------------------------------------------------
        // RSS
        case '/rss/channel/item/author':    $this->items[$this->rss_item_count-1]['author']    = $text; break; // ۿ
        case '/rss/channel/item/comments':  $this->items[$this->rss_item_count-1]['comments']  = $text; break; // ۿʪΥȤդƤڡURL
        case '/rss/channel/item/enclosure': $this->items[$this->rss_item_count-1]['enclosure'] = $attribute; break; // ۿʪźդƤǥ
        case '/rss/channel/item/pubDate':   $this->items[$this->rss_item_count-1]['date']      = $this->convertDateTime($text); break; // 
        case '/rss/channel/item/category': // ۿ
            $this->items[$this->rss_item_count-1]['category'] = $text;
            if (isset($attribute['domain'])) {
                $this->items_attribute[$this->rss_item_count-1]['category']['domain'] = $attribute['domain'];
            }
            break;
        case '/rss/channel/item/guid': // ۿʪ̥ˡID
            $this->items[$this->rss_item_count-1]['guid'] = $text;
            if (isset($attribute['isPermaLink'])) {
                $this->items_attribute[$this->rss_item_count-1]['guid']['isPermaLink'] = $attribute['isPermaLink'];
            }
            break;
        case '/rss/channel/item/source': // ۿʪRSS 2.0ե
            $this->items[$this->rss_item_count-1]['source'] = $text;
            if (isset($attribute['url'])) {
                $this->items_attribute[$this->rss_item_count-1]['source']['url'] = $attribute['url'];
            }
            break;

        default:
            // ¾Ǥϡver.0.91򻲾
            parent::getElement($current_path, $attribute, $text);
            break;
        }
    }
}

?>
