<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRssReader.php,v 1.1 2007/03/17 13:53:07 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * XML꡼饹
 */
require_once dirname(__FILE__) . '/../SyL_XmlReader.php';

/**
 * RSS꡼饹
 *
 * С̡ݲ
 *
 * [channel]
 *   copyright
 *   description
 *   language
 *   link
 *   date
 *   title
 *   category
 *
 * [image]
 *   height
 *   link
 *   title
 *   url
 *   width
 *
 * [textInput]
 *   description
 *   link
 *   name
 *   title
 *
 * [item]
 *   description
 *   link
 *   title
 *   author
 *   category
 *   date
 *   source
 *
 *  dateѴ
 *   1.0      - 2007-03-14T19:44:00+09:00       -> 2007/03/14 19:44:00
 *   0.91 2.0 - Mon, 12 Mar 2007 00:00:00 +0900 -> 2007/03/12 00:00:00
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRssReader.php,v 1.1 2007/03/17 13:53:07 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_XmlRssReader extends SyL_XmlReader
{
    /**
     * RSSС
     * 
     * @access protected
     * @var string
     */
    var $version = '';
    /**
     * RSSͥ
     * 
     * @access protected
     * @var array
     */
    var $channel = array();
    /**
     * RSͥ°
     * 
     * @access protected
     * @var array
     */
    var $channel_attribute = array();
    /**
     * RSSǡ
     * 
     * @access protected
     * @var array
     */
    var $items = array();
    /**
     * RSSǡ°
     * 
     * @access protected
     * @var array
     */
    var $items_attribute = array();

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_XmlRssReader()
    {
        parent::SyL_XmlReader();
        $this->channel = $this->initChannel();
    }

    /**
     * RSS󥹥󥹤
     *
     * @access public
     * @param string RSS XMLǡ
     * @param string RSS С
     * @return object RSS꡼֥
     */
    function &getInstance(&$data, $version='')
    {
        // С󤬻ꤵʤϼưȽ
        if (!$version) {
            if (preg_match('/<rss[^>]+version=\"([^\"]+)\"[^>]*>/i', $data, $matches)) {
                $version = $matches[1];
            } else if (strpos($data, '<rdf:RDF') !== false) {
                $version = '1.0';
            } else {
                trigger_error("[SyL error] Rss version undefined", E_USER_ERROR);
            }
        }

        // Ƭ100ХܤޤǤ˥󥳡ǥ󥰤ä
        $original_encode = '';
        if (preg_match ('/<\?xml(.*)encoding=\"(.+)\"(.*)\?>/i', substr(ltrim($data), 0, 100), $matches)) {
            $original_encode = $matches[2];
        }

        $classname = 'SyL_XmlRssReader' . str_replace('.', '_', $version);
        $include_file = dirname(__FILE__) . '/Reader/' . $classname . '.php';
        if (!file_exists($include_file)) {
            trigger_error("[SyL error] Rss version not supported ({$version})", E_USER_ERROR);
        }
        include_once $include_file;
        $reader =& new $classname();
        if ($original_encode) {
            $reader->setXmlEncode($original_encode);
        }
        $reader->setData($data);
        return $reader;
    }

    /**
     * ͥǤ
     *
     * @access protected
     * @return array ͥǤν
     */
    function initChannel()
    {
        return array(
          'category'    => null,
          'copyright'   => null,
          'date'        => null,
          'description' => null,
          'language'    => null,
          'link'        => null,
          'title'       => null
        );
    }

    /**
     * Ǥ
     *
     * @access protected
     * @return array Ǥν
     */
    function initImage()
    {
        return array(
          'height' => null,
          'link'   => null,
          'title'  => null,
          'url'    => null,
          'width'  => null
        );
    }

    /**
     * Ǥ
     *
     * @access protected
     * @return array Ǥν
     */
    function initTextInput()
    {
        return array(
          'description' => null,
          'link'        => null,
          'name'        => null,
          'title'       => null
        );
    }

    /**
     * Ǥ
     *
     * @access protected
     * @return array Ǥν
     */
    function initItem()
    {
        return array(
          'author'      => null,
          'category'    => null,
          'date'        => null,
          'description' => null,
          'link'        => null,
          'source'      => null,
          'title'       => null
        );
    }

    /**
     * ꤷͥ
     *
     * @access public
     * @return mixed ꤷͥ
     */
    function getChannel($name, $subname=null)
    {
        if ($subname) {
            return (isset($this->channel[$name][$subname]) ? $this->channel[$name][$subname] : null);
        } else {
            return (isset($this->channel[$name]) ? $this->channel[$name] : null);
        }
    }

    /**
     * ꤷͥ°
     *
     * @access public
     * @return array ꤷͥ°
     */
    function getChannelAttribute($name, $subname=null)
    {
        if ($subname) {
            return (isset($this->channel_attribute[$name][$subname]) ? $this->channel_attribute[$name][$subname] : null);
        } else {
            return (isset($this->channel_attribute[$name]) ? $this->channel_attribute[$name] : null);
        }
    }

    /**
     * ۿ
     *
     * @access public
     * @return array ۿ
     */
    function getItems()
    {
        return $this->items;
    }

    /**
     * ۿ°
     *
     * @access public
     * @return array ۿ°
     */
    function getItemAttribute($i, $name, $subname=null)
    {
        if ($subname) {
            return (isset($this->items_attribute[$i][$name][$subname]) ? $this->items_attribute[$i][$name][$subname] : null);
        } else {
            return (isset($this->items_attribute[$i][$name]) ? $this->items_attribute[$i][$name] : null);
        }
    }

    /**
     * եޥåȤѴ
     *
     * @access public
     * @param string Ѵ
     * @return string Ѵ
     */
    function convertDateTime($datetime)
    {
        $timestamp = @strtotime($datetime);
        if ($timestamp) {
            return date('Y/m/d H:i:s', $timestamp);
        } else {
            return $datetime;
        }
    }
}

?>
