<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRssWriter1_0.php,v 1.1 2007/03/17 13:53:07 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * RSS 1.0饹
 *
 * С̡ݲ
 *
 * [channel]
 *   dc:right  <- copyright
 *   description
 *   dc:language <- language
 *   link
 *   dc:date <- date
 *   title
 *   dc:subject <- category
 *
 * [image]
 *   height  <- (null)
 *   link
 *   title
 *   url
 *   width  <- (null)
 *
 * [textInput]
 *   description
 *   link
 *   name
 *   title
 *
 * [item]
 *   description
 *   link
 *   title
 *   dc:creator <- author
 *   dc:subject <- category
 *   dc:date    <- date
 *   dc:source  <- source
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRssWriter1_0.php,v 1.1 2007/03/17 13:53:07 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_XmlRssWriter1_0 extends SyL_XmlRssWriter
{
    /**
     * RSSС
     * 
     * @access protected
     * @var string
     */
    var $version = '1.0';

    /**
     * Ǥ򥻥åȤ
     * 
     * @access public
     * @param array 
     */
    function setImage($value)
    {
        parent::setImage($value);
        if (isset($this->image['height'])) {
            unset($this->image['height']);
        }
        if (isset($this->image['width'])) {
            unset($this->image['width']);
        }
    }

    /**
     * ͥǤ򥻥åȤ
     * 
     * @access public
     * @param string ̾
     * @param string 
     * @param array °
     */
    function setChannel($name, $value, $attributes=array())
    {
        // ݲ̾Ѵ
        switch ($name) {
        case 'copyright': $name = 'dc:right';    break;
        case 'language':  $name = 'dc:language'; break;
        case 'category':  $name = 'dc:subject';  break;
        case 'date':
            $name = 'dc:date';
            $value = $this->convertDateTime($value);
            break;
        }
        parent::setChannel($name, $value, $attributes);
    }

    /**
     * ܤ򥻥åȤ
     * 
     * @access public
     * @param string ̾
     * @param string 
     * @param array °
     */
    function addItem($values, $attributes=array())
    {
        // ݲ̾Ѵ
        foreach (array_keys($values) as $name) {
            switch ($name) {
            case 'author':
                $values['dc:creator'] = $values[$name];
                unset($values[$name]);
                break;
            case 'category':
                $values['dc:subject'] = $values[$name];
                unset($values[$name]);
                break;
            case 'date':
                $values['dc:date'] = $this->convertDateTime($values[$name]);
                unset($values[$name]);
                break;
            case 'source':
                $values['dc:source'] = $values[$name];
                unset($values[$name]);
                break;
            }
        }
        parent::addItem($values, $attributes);
    }

    /**
     * RSS XML
     * 
     * @access public
     */
    function createXml()
    {
        $rdf_about = '';
        if (isset($this->channel['link'])) {
            $rdf_about = $this->channel['link'];
        }

        $this->addStartElement('rdf:RDF',
          array(
            'xmlns:rdf' => 'http://www.w3.org/1999/02/22-rdf-syntax-ns#',
            'xmlns:dc'  => 'http://purl.org/dc/elements/1.1/',
            'xmlns'     => 'http://purl.org/rss/1.0/'
          )
        );
        $this->addStartElement('channel', array('rdf:about' => $rdf_about));
        // ͥ
        foreach ($this->channel as $name => $value) {
            $this->createRecursiveElements($name, $value);
        }
        // 
        if (count($this->image) > 0) {
            $this->addElement('image', array('rdf:resource' => $this->image['url']));
        }
        // ƥ
        if (count($this->textinput) > 0) {
            $this->addElement('textinput', array('rdf:resource' => $this->textinput['link']));
        }
        // ƥ
        if (count($this->items) > 0) {
            $this->addStartElement('items');
            $this->addStartElement('rdf:Seq');
            foreach ($this->items as $item) {
                $this->addElement('rdf:li', array('resource' => $item['link']));
            }
            $this->addEndElement();
            $this->addEndElement();
        }
        $this->addEndElement();

        // 
        if (count($this->image) > 0) {
            $this->addStartElement('image', array('rdf:about' => $this->image['url']));
            foreach ($this->image as $name => $value) {
                $this->createRecursiveElements($name, $value);
            }
            $this->addEndElement();
        }

        // ƥ
        if (count($this->textinput) > 0) {
            $this->addStartElement('textinput', array('rdf:about' => $this->image['link']));
            foreach ($this->textinput as $name => $value) {
                $this->createRecursiveElements($name, $value);
            }
            $this->addEndElement();
        }

        // ƥ
        foreach ($this->items as $item) {
            $this->addStartElement('item', array('rdf:about' => $item['link']));
            foreach ($item as $name => $value) {
                $this->createRecursiveElements($name, $value);
            }
            $this->addEndElement();
        }

        $this->addEndElement();
        $this->addEndElement();
    }

    /**
     * եޥåȤѴ
     *
     *  2007/03/14 19:44:00 -> 2007-03-14T19:44:00+09:00
     *
     * @access public
     * @param string Ѵ
     * @return string Ѵ
     */
    function convertDateTime($datetime)
    {
        if (preg_match('/^(\d{4})(\-|\/)([0-1][0-9])(\-|\/)([0-3][0-9])( [0-2][0-9]:[0-5][0-9]:[0-5][0-9])?$/', trim($datetime))) {
            $timestamp = @strtotime($datetime);
            if ($timestamp) {
                $datetime = date('Y-m-d\TH:i:s+09:00', $timestamp);
            }
        }
        return $datetime;
    }

}

?>
