<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRssReader0_91.php,v 1.1 2007/03/17 13:53:07 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * RSS 0.91꡼饹
 *
 * С̡ݲ
 *
 * [channel]
 *   copyright
 *   description
 *   language
 *   link
 *   date     <- pubDate
 *   title
 *   category <- (null)
 *
 * [image]
 *   height
 *   link
 *   title
 *   url
 *   width
 *
 * [textInput]
 *   description
 *   link
 *   name
 *   title
 *
 * [item]
 *   description
 *   link
 *   title
 *   author   <- (null)
 *   category <- (null)
 *   date     <- (null)
 *   source   <- (null)
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRssReader0_91.php,v 1.1 2007/03/17 13:53:07 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_XmlRssReader0_91 extends SyL_XmlRssReader
{
    /**
     * RSSС
     * 
     * @access protected
     * @var string
     */
    var $version = '0.91';
    /**
     * Ȥιܿ
     * 
     * @access protected
     * @var int
     */
    var $rss_item_count = 0;

    /**
     * XMLǡƼϥɥ᥽å
     * С饤
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
//echo $current_path . "\n";

        // XMLϷ̤
        switch ($current_path) {
        // С
        case '/rss':
            if (isset($attribute['version'])) {
                $this->version = $attribute['version'];
            }
            break;

        // -------------------------------------------------
        // إå
        // -------------------------------------------------
        case '/rss/channel/title':          $this->channel['title']          = $text; break; // ȥ
        case '/rss/channel/link':           $this->channel['link']           = $text; break; // 
        case '/rss/channel/description':    $this->channel['description']    = $text; break; // 
        case '/rss/channel/language':       $this->channel['language']       = $text; break; // 
        case '/rss/channel/copyright':      $this->channel['copyright']      = $text; break; // ԡ饤
        case '/rss/channel/managingEditor': $this->channel['managingEditor'] = $text; break; // ꥽Ǥ
        case '/rss/channel/webMaster':      $this->channel['webMaster']      = $this->convertDateTime($text); break; // ꥽Ǥ
        case '/rss/channel/pubDate':        $this->channel['date']           = $this->convertDateTime($text); break; // ꥽κ Sat, 07 Sep 2002 00:00:01 GMT
        case '/rss/channel/lastBuildDate':  $this->channel['lastBuildDate']  = $text; break; // ǽ Sat, 07 Sep 2002 00:00:01 GMT
        case '/rss/channel/docs':           $this->channel['docs']           = $text; break;
        case '/rss/channel/rating':         $this->channel['rating']         = $text; break;
        // 
        case '/rss/channel/image':
            // ɬ°
            $this->channel['image'] = $this->initImage();
            break;
        case '/rss/channel/image/url':         $this->channel['image']['url']         = $text; break; // URL
        case '/rss/channel/image/title':       $this->channel['image']['title']       = $text; break; // ȥ
        case '/rss/channel/image/link':        $this->channel['image']['link']        = $text; break; // 
        case '/rss/channel/image/width':       $this->channel['image']['width']       = $text; break; //   Maximum value for width  is 144, default value is 88.
        case '/rss/channel/image/height':      $this->channel['image']['height']      = $text; break; //   Maximum value for height is 400, default value is 31.
        case '/rss/channel/image/description': $this->channel['image']['description'] = $text; break; // 
        // 
        case '/rss/channel/textInput':
            // ɬ°
            $this->channel['textinput'] = $this->initTextInput();
            break;
        case '/rss/channel/textInput/title':       $this->channel['textinput']['title']       = $text; break; // ǥ٥
        case '/rss/channel/textInput/name':        $this->channel['textinput']['name']        = $text; break; // ̾
        case '/rss/channel/textInput/description': $this->channel['textinput']['description'] = $text; break; // ǥեʸ
        case '/rss/channel/textInput/link':        $this->channel['textinput']['link']        = $text; break; // ǥեʸ
        // åߤʤ
        case '/rss/channel/skipHours':      $this->channel['skipHours'] = array(); break;
        case '/rss/channel/skipHours/hour': $this->channel['skipHours']['hour'][] = $text; break;
        // åߤʤ
        case '/rss/channel/skipDays':     $this->channel['skipDays'] = array(); break;
        case '/rss/channel/skipDays/day': $this->channel['skipDays']['day'][] = $text; break;

        // -------------------------------------------------
        // ǡ
        // -------------------------------------------------
        // RSS
        case '/rss/channel/item':
            // ɬ°
            $this->items[] = $this->initItem();
            $this->rss_item_count = count($this->items);
            break;
        case '/rss/channel/item/title':       $this->items[$this->rss_item_count-1]['title']       = $text; break; // ȥ
        case '/rss/channel/item/link':        $this->items[$this->rss_item_count-1]['link']        = $text; break; // 
        case '/rss/channel/item/description': $this->items[$this->rss_item_count-1]['description'] = $text; break; // 
        }
    }
}

?>
