/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id:$
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * Ajaxִ̿饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id:$
 * @link      http://www.syl.jp/
 */
var SyL_AjaxLoading = {
  func      : [],
  timer     : [],
  id        : '_syl_iframe',
  timeout   : 500,
  exclusive : [],
  process : function(form, url, config, parameter)
  {
    var i = SyL_AjaxLoading.func.length;
    if (config && config.exclusive) {
      for (var j in SyL_AjaxLoading.exclusive) {
        if (SyL_AjaxLoading.exclusive[j] == config.exclusive) {
          return false;
        }
      }
      SyL_AjaxLoading.exclusive[i] = config.exclusive;
    } else {
      SyL_AjaxLoading.exclusive[i] = null;
    }

    var id = SyL_AjaxLoading.id + i;
    var div = document.createElement('div');
    div.innerHTML = '<iframe style="display:none" src="javascript:false;" id="' + id + '" name="' + id + '" onLoad="SyL_AjaxLoading.loaded(\'' + url + '\', \'' + i + '\', \'' + parameter + '\')"></iframe>';
    document.body.appendChild(div);
    form.target = id;

    var start = false;
    if (config) {
      if (typeof(config.loaded) == 'function') {
        var iframe = document.getElementById(id);
        iframe.loaded = config.loaded;
      }
      if (typeof(config.start) == 'function') {
        start = config.start(parameter);
      } else {
        start = true;
      }
      if (start && (typeof(config.loading) == 'function')) {
        SyL_AjaxLoading.func[i] = config.loading;
        SyL_AjaxLoading.loading(url, i, parameter);
      }
    } else {
      start = true;
    }

    return start;
  },

  loading : function(url, i, parameter)
  {
    if (typeof(SyL_AjaxLoading.func[i]) != 'function') {
      return;
    }
    SyL_AjaxLoading.func[i](url, parameter);
    SyL_AjaxLoading.timer[i] = setTimeout("SyL_AjaxLoading.loading('" + url + "', " + i + ", '" + parameter + "')", SyL_AjaxLoading.timeout);
  },

  loaded : function(url, i, parameter)
  {
    var id = SyL_AjaxLoading.id + i;
    var iframe = document.getElementById(id);
    var doc;
    if (iframe.contentDocument) {
      doc = iframe.contentDocument;
    } else if (iframe.contentWindow) {
      doc = iframe.contentWindow.document;
    } else {
      doc = window.frames[id].document;
    }
    if (doc.location.href == "javascript:false;") {
        return;
    }

    SyL_AjaxLoading.func[i]      = null;
    SyL_AjaxLoading.exclusive[i] = null;
    if (SyL_AjaxLoading.timer[i]) {
      clearTimeout(SyL_AjaxLoading.timer[i]);
      SyL_AjaxLoading.timer[i] = null;
    }

    if (typeof(iframe.loaded) == 'function') {
      iframe.loaded(url, doc.body.innerHTML, parameter);
    }
  }
}

