<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Container.php,v 1.16 2007/03/31 08:45:29 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * եɤ߹९饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_Config.php';

/**
 * ƥʥ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Container.php,v 1.16 2007/03/31 08:45:29 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Container
{
    /**
     * ƥ
     * 
     * @access private
     * @var array
     */
    var $config = array();
    /**
     * ץꥱ᥽å
     * 
     * @access private
     * @var array
     */
    var $app_config = array();
    /**
     * ݡͥȥ֥ȳǼ
     * 
     * @access private
     * @var array
     */
    var $components = array();
    /**
     * ݡͥȥ֥ȥ᥽åͳǼ
     * ᥽åɥ󥸥η̤Τ
     * ʣƱ᥽åɤƤӽФϺǸη̤Τ߼ǽ
     * 
     * @access private
     * @var array
     */
    var $component_returns = array();

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_Container()
    {
    }

    /**
     * ƥʤ
     *
     * @access public
     * return object ƥʥ֥
     */
    function &getContainer()
    {
        static $singleton;
        if (!is_object($singleton)) {
            $singleton = new SyL_Container();
        }
        return $singleton;
    }

    /**
     * ٥ȵư
     * եɤ߹ߥƥʤϿ or ¹
     *
     * @access public
     * @param string ٥ȥ᥽å̾
     * @param string ե
     * @param string ¹ԥݡͥ̾
     */
    function raiseEvent($event, $config_type=array(), $component_name='')
    {
        // ٥ȳϥ
        $this->log('debug', "$event event start");
        // ݻ
        $tmp_config = array();

        // եɤ߹
        if ($event == 'appStream') {
            if ($component_name == '') {
                // ݡͥȤꤵƤʤȵưʤ
                return;
            }
            if (count($config_type) > 0) {
                $this->app_config += $this->readConfig($event, $config_type);
            }
            if (!isset($this->app_config[$component_name])) {
                trigger_error("[SyL error] Application Component not exists ({$component_name})", E_USER_ERROR);
            }
            $tmp_config[$component_name] =& $this->app_config[$component_name];

        } else {
            if (count($config_type) > 0) {
                $this->config += $this->readConfig($event, $config_type);
                // ̥ͥȽ
                uasort($this->config, array(&$this, 'sortConfig'));
            }
            $tmp_config =& $this->config;
        }

        // ƥʤ
        if ($event == 'finalStream') {
            $this->log('debug', "$event event global config ..." . print_r($this->config, true));
            //$this->log('debug', "$event event application config ..." . print_r($this->app_config, true));
        }
/*
echo "-------------- " . $event . " ---------------------------------------------------<br>";

echo "<pre>";
print_r($this->config);
echo "</pre>";

*/

        // ݡͥȼ¹ԥ롼
        foreach ($tmp_config as $name => $keys) {
            $classname = $keys['class'];

            // ٥ȤʤХå
            if (count($keys['event']) == 0) {
                continue;
            }

            // 󥹥ȥ饯󥸥Ǥ뤫ޤϴ˥ݡͥȤ¸ߤХå
            if (!$keys['constructor'] && !$this->isComponent($name)) {
                // ݡͥȥ٥ȥå
                if (!isset($keys['event'][$event]) || !in_array($name, $keys['event'][$event])) {
                    continue;
                }

                // ݡͥȤ
                if (!$this->LoadLib($keys['file'])) {
                    // ٥Ⱥ
                    $this->deleteEventConfig($name, $name, $event, $keys, $tmp_config);
                    continue;
                }

                // 饹Ƚ
                if (!class_exists($classname)) {
                    // 饹̵
                    trigger_error("[SyL error] Component class not found (class name: {$classname})", E_USER_ERROR);
                }
                if ($keys['reference']) {
                    $component =& new $classname();
                } else {
                    $component = new $classname();
                }
                $this->setComponent($name, $component);
                // ֥Ⱥ
                unset($component);
                // ٥Ⱥ
                $this->deleteEventConfig($name, $name, $event, $keys, $tmp_config);
            }

            foreach ($keys['args'] as $func => $args) {
                // ᥽åɥ٥ȥå
                if (!isset($keys['event'][$event]) || !in_array($func, $keys['event'][$event])) {
                    continue;
                }

                $eval_args  = '';
                $value_args = array();
                for ($i=0; $i<count($args); $i++) {
                    list($type, $ref, $value) = explode(':', $args[$i], 3);
                    switch ($type) {
                    case 'constant':
                        if ($ref === 'true') {
                            $value_args[$i] =& constant($value);
                        } else {
                            $value_args[$i] = constant($value);
                        }
                        break;

                    case 'component':
                        $classmethod = explode('.', $value, 2);
                        $obj =& $this->getComponent($classmethod[0]);
                        if (isset($classmethod[1])) {
                            if (($idx = strpos($classmethod[1], '(')) !== false) {
                                $method = substr($classmethod[1], 0, $idx);
                                // ᥽åɤ¸ߤΤߥå
                                if (method_exists($obj, $method)) {
                                    if ($ref === 'true') {
                                        $value_args[$i] =& $obj->$method();
                                    } else {
                                        $value_args[$i] = $obj->$method();
                                    }
                                }
                            } else {
                                $property = $classmethod[1];
                                // ץѥƥ¸ߤΤߥå
                                if (array_key_exists($property, get_object_vars($obj))) {
                                    if ($ref === 'true') {
                                        $value_args[$i] =& $obj->$property;
                                    } else {
                                        $value_args[$i] = $obj->$property;
                                    }
                                }
                            }
                        } else {
                            if ($ref === 'true') {
                                $value_args[$i] =& $obj;
                            } else {
                                $value_args[$i] = $obj;
                            }
                        }
                        break;

                    default:
                      if ($ref === 'true') {
                        $value_args[$i] =& $value;
                      } else {
                        $value_args[$i] = $value;
                      }
                      break;
                    }
                    $eval_args .= ($eval_args == '') ? '$value_args[' . $i . ']' : ', $value_args[' . $i . ']';
                }

                $funcs = explode(':', $func);
                switch (strtolower($funcs[0])) {
                case 'constructor':
                    // ݡͥȤ
                    if ($this->LoadLib($keys['file'])) {
                        $ref = $keys['reference'] ? '&' : '';
//echo '$component =' . $ref . ' ' . $classname  . '::' . $funcs[1] . '(' . $eval_args . ');' . "<br>";
                        if ($funcs[1] != '') {
                            eval('$component =' . $ref . ' ' . $classname  . '::' . $funcs[1] . '(' . $eval_args . ');');
                        } else {
                            eval('$component =' . $ref . ' new ' . $classname . '(' . $eval_args . ');' ); 
                        }
                        $this->setComponent($name, $component);
                    }
                    break;

                case 'method':
                    $component =& $this->getComponent($name);
                    $method_name = $name . '.' . $funcs[1];
                    if (method_exists($component, $funcs[1])) {
                        $this->component_returns[$method_name] = call_user_func_array(array(&$component, $funcs[1]), $value_args);
                    } else {
                        // ͽʤ᥽åɤμ¹Ԥϥ顼
                        if (class_exists('SyL_Response')) {
                            $this->log('warn', "Method injection failed: method not found (" . get_class($component) . ".{$funcs[1]})");
                            SyL_Response::redirect404();
                        } else {
                            trigger_error("[SyL error] Method injection failed: method not found (" . get_class($component) . ".{$funcs[1]})", E_USER_ERROR);
                        }
                    }
                    break;

                case 'setter':
                    $component =& $this->getComponent($name);
                    if ($funcs[2] === 'true') {
                        if (array_key_exists($funcs[1], get_object_vars($component))) {
                            foreach ($value_args as $key => $value) {
                                if ($keys['reference']) {
                                    $component->$funcs[1] =& $value_args[$key];
                                } else {
                                    $component->$funcs[1] = $value_args[$key];
                                }
                            }
                        } else {
                            $this->log('info', "Setter injection failed: setter not found (" . get_class($component) . ".{$funcs[1]})");
                        }
                    } else {
                        if (method_exists($component, $funcs[1])) {
                            call_user_func_array(array(&$component, $funcs[1]), $value_args);
                        } else {
                            $this->log('info', "Setter injection failed: setter not found (" . get_class($component) . ".{$funcs[1]})");
                        }
                    }
                    break;
                }

                // ֥Ⱥ
                unset($component);
                // ٥Ⱥ
                $this->deleteEventConfig($name, $func, $event, $keys, $tmp_config);
            }
        }
    }

    /**
     * եɤ߹
     *
     * @access private
     * @param string ٥̾
     * @param string եΥ
     * @return array ե
     */
    function readConfig($event, $config_type)
    {
        $config = array();
        foreach ($config_type as $type => $file) {
            $reader =& SyL_Config::getObject($type, $file, $this->getComponent(SYL_CONTROLLER_NAME), $event);
            $reader->parseXml();
            $config += $reader->getConfig();
        }
        return $config;
    }

    /**
     * ¹Խ̤ͥȤ˥Ȥ
     *
     * @access public
     * @param array ߤ
     * @param array 
     * @return object ݡͥȥ֥
     */
    function sortConfig($current, $next)
    {
        return strcmp($current['priority'], $next['priority']);
    }

    /**
     * 饤֥
     *
     * @access public
     * @param string ɥե
     * @return bool true: OK, false, NG
     */
    function LoadLib($file)
    {
        if (is_file(SYL_INCLUDE_DIR . "/{$file}")) {
            // SyLǥ쥯ȥ꤫Υѥ
            include_once SYL_INCLUDE_DIR . "/{$file}";
        } else if (is_file(SYL_WEBAPP_LIB_DIR . "/{$file}")) {
            // ץꥱǥ쥯ȥ꤫Υѥ
            include_once SYL_WEBAPP_LIB_DIR . "/{$file}";
        } else if (is_file($file)) {
            // եѥ
            include_once $file;
        } else {
            // ݡͥȥե뤬̵
            $this->log('info', "Component include failed: file not found (" . SYL_INCLUDE_DIR . "/{$file} or " . SYL_WEBAPP_LIB_DIR . "/{$file} or {$file})");
            return false;
        }
        return true;
    }

    /**
     * ٥
     *
     * @access private
     * @param string ̾
     * @param string ᥽å̾
     * @param string ٥̾
     * @param array ߤ̾Ф
     * @param array 
     */
    function deleteEventConfig($name, $func, $event, &$keys, &$config)
    {
        // ٥Ⱥ
        if (isset($keys['event']['*'])) {
            $index = array_search($func, $keys['event']['*']);
            if ($index !== false) {
                unset($config[$name]['event']['*'][$index]);
                if (count($config[$name]['event']['*']) == 0) {
                    unset($config[$name]['event']['*']);
                }
            }
        } else if (isset($keys['event'][$event])) {
            $index = array_search($func, $keys['event'][$event]);
            if ($index !== false) {
                unset($config[$name]['event'][$event][$index]);
                if (count($config[$name]['event'][$event]) == 0) {
                    unset($config[$name]['event'][$event]);
                }
            }
        }
    }

    /**
     * ƥͤ
     *
     * @access public
     * @return array ƥ
     */
    function getConfig()
    {
        return $this->config;
    }

    /**
     * ץꥱ᥽åͤ
     *
     * @access public
     * @return array ץꥱ᥽å
     */
    function getAppConfig()
    {
        return $this->app_config;
    }

    /**
     * ݡͥȤ
     *
     * @access public
     * @return object ݡͥȥ֥
     */
    function &getComponent($name)
    {
        if (!$this->isComponent($name)) {
            
            trigger_error("[SyL error] Component not found in container ($name)", E_USER_ERROR);
        }
        return $this->components[$name];
    }

    /**
     * ݡͥȤ򥻥å
     *
     * @access public
     * @param string ݡͥ̾
     * @param object ݡͥȥ֥
     */
    function setComponent($name, &$component)
    {
        $this->components[$name] =& $component;
    }

    /**
     * ݡͥȤ¸Ƚ
     *
     * @access public
     * @param string ݡͥ̾
     * @param bool true: ¸ߤ롢false: ¸ߤʤ
     */
    function isComponent($name)
    {
        return isset($this->components[$name]);
    }

    /**
     * ݡͥȤκ
     *
     * @access public
     * @param string ݡͥ̾
     */
    function deleteComponent($name)
    {
        unset($this->components[$name]);
    }

    /**
     * ݡͥȥ᥽åɤη̤
     * ʣƱ᥽åɤƤӽФϺǸη̤Τ߼ǽ
     *
     * @access public
     * @param string ݡͥ̾ + '.' + ᥽å̾
     * @return string ݡͥȥ᥽åɤη
     */
    function getComponentMethodResult($name)
    {
        return $this->component_returns[$name];
    }

    /**
     * ¸
     *
     * @access private
     * @param string ¸ʸ
     */
    function log($type, $message)
    {
        if ($this->isComponent('log')) {
            SyL_Loggers::$type("[Container] " . $message);
        }
    }
}

?>
