<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ViewJs.php,v 1.5 2007/03/17 13:53:07 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * JavaScriptϥ饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_Js.php';

/**
 * JavaScriptӥ塼饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ViewJs.php,v 1.5 2007/03/17 13:53:07 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ViewJs extends SyL_View
{
    /**
     * Jsϥ֥
     * 
     * @access protected
     * @var object
     */
    var $js = null;

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_ViewJs(&$dm)
    {
        parent::SyL_View($dm);
        // ƥĥפ򥻥å
        $this->setContentType('application/x-javascript; charset=' . SYL_ENCODE_INTERNAL);
        $this->js =& new SyL_Js();
    }

    /**
     * JavaScript򥤥ݡȤ
     * 
     * @access public
     */
    function importJs()
    {
        $request =& SyL_Request::getInstance();
        $this->js->import($request->getParameter('import'));
    }

    /**
     * JavaScript󥰼¹
     * 
     * @access public
     */
    function render()
    {
        $this->importJs();
        // JavaScirpt
        $this->setRender($this->js->getJs());
    }
}

?>
