<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBPdopgsql.php,v 1.2 2007/04/14 09:59:36 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * DB饹PDO
 */
require_once 'SyL_DBPdo.php';

/**
 *  DB饹PDO::Pgsql
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBPdopgsql.php,v 1.2 2007/04/14 09:59:36 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DBPdopgsql extends SyL_DBPdo
{
    /**
     * 󥳡Ѵơ֥
     *
     *  PostgreSQL <=> PHP
     *  (client)       (client)
     * 
     * ƾʸǵ
     *
     * @access protected
     * @var string
     */
    public $encode_table = array(
      // PHP, DB
      array('eucjp-win', 'euc-jp'),
      array('euc-jp',    'euc-jp'),
      array('euc',       'euc-jp'),
      array('sjis-win',  'sjis' ),
      array('sjis-win',  'mskanji'),
      array('sjis-win',  'shiftjis'),
      array('sjis-win',  'win932'),
      array('sjis-win',  'windows932'),
      array('sjis',      'sjis'),
      array('utf-8',     'utf8'),
      array('utf-8',     'unicode')
    );

    /**
     * DB³¹
     * 
     * @access public
     * @param string ǡ١̾
     * @param string 桼̾
     * @param string ѥ
     * @param string ۥ̾
     * @param string ݡֹ
     * @param bool ³Ū³Ԥ
     * @return boolean ³OK: true, ³NG: false
     */
    public function openConnection($dbname, $user, $passwd, $host, $port, $persistent)
    {
        $conn_dbtype  = substr($this->dbname, 3);
        $conn_strings = array();
        if ($user) $conn_strings[]   = 'user='     . $user;
        if ($passwd) $conn_strings[] = 'password=' . $passwd;
        if ($dbname) $conn_strings[] = 'dbname='   . $dbname;
        if ($host) $conn_strings[]   = 'host='     . $host;
        if ($port) $conn_strings[]   = 'port='     . $port;

        $conn_string = $conn_dbtype . ':' . implode(' ', $conn_strings);
        return $this->pdoConnection($conn_string);
    }

    /**
     * 饤¦ʸ󥳡ƥ
     * 
     * @access public
     * @param string DBʸ
     * @param string PHP¦󥳡
     */
    public function setClientEncoding($client_encode, $server_encode='')
    {
        $client_encode2 = strtolower($client_encode);
        foreach ($this->encode_table as $encode_table) {
            if ($encode_table[0] == $client_encode2) {
                $client_encode2 = $encode_table[1];
                break;
            }
        }
        $this->connection->exec("SET CLIENT_ENCODING TO {$client_encode2}");
        parent::setClientEncoding($client_encode, $server_encode);
    }

    /**
     * SQL¹Ԥڡ˥ǡ
     *
     * @access public
     * @param string SQLʸ
     * @param array ¹Է̳Ǽ
     * @param object ڡ֥
     * @param int 1ڡɽ
     * @param int ɽоݥڡ 
     * @return bool ¹Է
     */
    public function queryPageRef($sql, &$result, &$pager, $limit=20, $page=1)
    {
        // ڡ󥰥֥
        $pager = $this->getPager($limit, $page);
        // SQL
        $sql_count = "SELECT COUNT(*) FROM (" . $sql . ") AS SyL$";
        // SQL¹
        if (!$this->queryRef($sql_count, $record, 'one')) return false;
        $pager->setCountAll($record);

        // ڡñ̥쥳ɼ
        $sql_page  = $sql;
        $sql_page .= " LIMIT "  . $pager->getCount();
        $sql_page .= " OFFSET " . $pager->getStartOffset();

        // ǡSQL¹
        return $this->queryRef($sql_page, $result, 'all');
    }

    /**
     * ³ƤDBСΥС
     * 
     * @access public
     * @return string DBΥС
     */
    public function getVersion()
    {
        $sql = "SELECT VERSION()";
        $this->queryRef($sql, $version, 'one');
        if (preg_match('/^PostgreSQL (.+) on .+$/', trim($version), $matches)) {
            $version = $matches[1];
        }
        return $version;
    }
}

?>
