<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_HttpClientParameter.php,v 1.1 2007/03/17 13:53:08 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ѥץѥƥ饹
 */
require_once dirname(__FILE__) . '/../Util/SyL_UtilParameter.php';

/**
 * HTTP饤ȥѥ᡼饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_HttpClientParameter.php,v 1.1 2007/03/17 13:53:08 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_HttpClientParameter
{
    /**
     * HTTPꥯоURL
     *
     * @access private
     * @var string
     */
    var $url = '';
    /**
     * HTTPꥯȥ᥽å
     *
     * @access private
     * @var string
     */
    var $method = '';
    /**
     * ꥯȥإåǼ֥
     *
     * @access private
     * @var string
     */
    var $headers = null;
    /**
     * ꥯȥѥ᡼Ǽ֥
     *
     * @access private
     * @var string
     */
    var $parameters = null;
    /**
     * 桼
     *
     * @access private
     * var string
     */
    var $useragent = 'SyL_HttpClient in SyL Framework';
    /**
     * ԥ
     *
     * @access private
     * @var string
     */
    var $eol = "\r\n";

    /**
     * 󥹥ȥ饯
     * 
     * @access public
     * @param string HTTPꥯоURL
     * @param string HTTPꥯȥ᥽å
     */
    function SyL_HttpClientParameter($url='/', $method='GET')
    {
        $this->url    = $url;
        $this->method = strtoupper($method);

        $this->headers    = new SyL_UtilParameter();
        $this->parameters = new SyL_UtilParameter();

        if ($this->method == 'POST') {
            $this->setHeader('content-type', 'application/x-www-form-urlencoded');
        }

        $this->setHeader('connection', 'Close');
        $this->setUserAgent($this->useragent);
    }

    /**
     * 桼Ȥ򥻥å
     * 
     * @access public
     * @param string 桼
     */
    function setUserAgent($value)
    {
        $this->headers->set('user-agent', $value);
    }

    /**
     * BasicǧڤID, ѥɤ򥻥å
     *
     * @access public
     * @param string 桼̾
     * @param string ѥ
     */
    function setAuthorization($username, $password)
    {
        $this->headers->set('authorization', 'Basic ' . base64_encode("{$username}:{$password}"));
    }

    /**
     * إå򥻥å
     * 
     * @access public
     * @param string ѥ᡼̾
     * @param string ѥ᡼
     */
    function setHeader($name, $value)
    {
        $this->headers->set(strtolower($name), $value);
    }

    /**
     * ƤΥإå
     * 
     * @access public
     * @return array ƤΥإå
     */
    function getHeaders()
    {
        $headers = array();
        foreach ($this->headers->gets() as $name => $value) {
            $name = preg_replace('/(^.|\-.)/e', 'strtoupper("$1")', $name);
            $headers[$name] = $value;
        }
        return $headers;
    }

    /**
     * ѥ᡼򥻥å
     * 
     * @access public
     * @param string ѥ᡼̾
     * @param string ѥ᡼
     */
    function set($name, $value)
    {
        $this->parameters->set($name, $value);
    }

    /**
     * ѥ᡼ꥯȷѴ
     * 
     * @access protected
     * @return string ѥ᡼
     */
    function build()
    {
        $parameter = array();
        foreach ($this->parameters->gets() as $name => $value) {
            $parameter[] = urlencode($name) . '=' .  urlencode($value);
        }
        return implode('&', $parameter);
    }

    /**
     * ꥯȥإå
     * 
     * @access public
     * @return string ꥯȥإå
     */
    function getSource()
    {
        $parameter = $this->build();
        $url = $this->url;
        switch ($this->method) {
        case 'GET':
            if ($parameter) {
                 $url .= '?' . $parameter;
            }
            break;
        case 'POST':
            $this->setHeader('content-length', strlen($parameter));
            break;
        }

        $source  = "";
        $source .= "{$this->method} {$url} HTTP/1.1" . $this->eol;
        foreach ($this->getHeaders() as $name => $value) {
            $source .= "{$name}: $value" . $this->eol;
        }
        $source .= $this->eol;
        if ($this->method == 'POST') {
            $source .= $parameter;
        }
        return $source;
    }
}

?>
