<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilCompositeComponent.php,v 1.2 2007/03/17 13:53:08 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ݥåȥѥ˴Ť쥯饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilCompositeComponent.php,v 1.2 2007/03/17 13:53:08 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_UtilCompositeComponent
{
    /**
     * ̾
     * 
     * @access private
     * @var string
     */
    var $name = '';
    /**
     * °
     *
     * @access private
     * @var array
     */
    var $attributes = array();

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param string ̾
     * @param array °
     */
    function SyL_UtilCompositeComponent($name=null, $attributes=array())
    {
        if ($name !== null) {
            $this->setName($name);
        }
        $this->attributes += $attributes;
    }

    /**
     * ̾Τ򥻥å
     *
     * @access protected
     * @param string ̾
     */
    function setName($name)
    {
        $this->name = $name;
    }

    /**
     * ̾Τ
     *
     * @access protected
     * @return string ̾
     */
    function getName()
    {
        return $this->name;
    }

    /**
     * °򥻥å
     *
     * @access protected
     * @param string °̾
     * @param string °
     */
    function setAttribute($name, $value)
    {
        $this->attributes[$name] = $value;
    }

    /**
     * °
     *
     * @access protected
     * @param string °̾
     * @return string °
     */
    function getAttribute($name)
    {
        return $this->attributes[$name];
    }

    /**
     * °
     *
     * @access protected
     * @return array °
     */
    function getAttributes()
    {
        return $this->attributes;
    }

    /**
     * Ǥɲä
     *
     * @access public
     * @param string CSVǡ֥
     */
    function add($node)
    {
    }

    /**
     * ĥ꡼ɽ
     *
     * @access public
     * @param int 
     */
    function printTree($depth=0)
    {
        echo str_repeat('    ', $depth);
        echo "{$this->name}\n";
    }

    /**
     * ĥ꡼
     *
     * @access public
     * @param array ĥ꡼ǡ
     */
    function getTree($tree=array())
    {
        $tree['name']       = $this->name;
        $tree['attributes'] = $this->getAttributes();
        $tree['nodes']      = array();
        return $tree;
    }
}

?>
