<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidationConfig.php,v 1.1 2007/03/31 08:45:29 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ꥯ饹
 * 
 * array(
 *   'def1' => array(
 *     [0] => array(
 *       'validator'    => 'require',
 *       'errorMessage' => '{name}ɬܤǤ',
 *       'options' => array(
 *         'max'   => '19',
 *         'min'   => '1'
 *       )
 *     ),
 *     [1] => ...
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidationConfig.php,v 1.1 2007/03/31 08:45:29 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ValidationConfig
{
    /**
     * ե̾
     *
     * @access protected
     * @var string
     */
    var $filename = '';
    /**
     * 
     *
     * @access protected
     * @var array
     */
    var $config = array();
    /**
     * ̾
     *
     * @access protected
     * @var array
     */
    var $config_name = array();

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param string ե̾
     */
    function SyL_ValidationConfig($filename)
    {
        $this->filename = $filename;
    }

    /**
     * ꥪ֥Ȥ
     *
     * @static
     * @access public
     * @param string ե̾
     * @param string եγĥ
     * @return object ꥪ֥
     */
    function &getConfig($filename, $ext='')
    {
        if (!$ext) {
            $ext = pathinfo($filename, PATHINFO_EXTENSION);
        }

        if (!file_exists($filename)) {
            trigger_error("[SyL error] Config file not found ({$filename})", E_USER_ERROR);
        }

        if (!is_readable($filename)) {
            trigger_error("[SyL error] Config file not readable ({$filename})", E_USER_ERROR);
        }

        $classdir  = dirname(__FILE__) . '/Config/';
        $classname = 'SyL_ValidationConfig' . ucfirst($ext);
        if (!file_exists($classdir . $classname . '.php')) {
            trigger_error("[SyL error] Not Supported extension ({$ext})", E_USER_ERROR);
        }

        include_once $classdir . $classname . '.php';
        $obj =& new $classname($filename);
        $obj->parse();
        return $obj;
    }

    /**
     * ѡ
     *
     * @access protected
     */
    function parse()
    {
    }

    /**
     * ͤ鸡ڥ롼ץ֥Ȥ
     *
     * @access public
     * @param string ꥭ
     * @return object ڥ롼ץ֥
     */
    function &get($pattern)
    {
        if (!isset($this->config[$pattern])) {
            trigger_error("[SyL error] Pattern not found ({$pattern})", E_USER_ERROR);
        }
        $group =& SyL_Validators::create();
        foreach ($this->config[$pattern] as $config) {
            $options = isset($config['options']) ? $config['options'] : array();
            $group->add(SyL_Validator::create($config['validator'], $config['errorMessage'], $options));
        }
        return $group;
    }

    /**
     * ͤ鸡ڥ롼̾
     *
     * @access public
     * @param string ꥭ
     * @return string ڥ롼̾
     */
    function getName($pattern)
    {
        if (!isset($this->config_name[$pattern])) {
            trigger_error("[SyL error] Display name not found ({$pattern})", E_USER_ERROR);
        }
        if ($this->config_name[$pattern] !== '') {
            $pattern = $this->config_name[$pattern];
        }
        return $pattern;
    }

    /**
     * ͤͤ
     *
     * @access public
     * @return array ꥭ
     */
    function getKeys()
    {
        return array_keys($this->config);
    }

}

?>
