<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidationValidatorLength.php,v 1.2 2007/04/14 09:59:36 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * Хȿڥ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidationValidatorLength.php,v 1.2 2007/04/14 09:59:36 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ValidationValidatorLength extends SyL_ValidationValidator
{
    /**
     * ѥ᡼
     *
     * @access protected
     * @var array
     */
    var $parameters = array(
      'min'       => 0,
      'min_error' => null,
      'max'       => null,
      'max_error' => null
    );

    /**
     * ʸڽ¹Ԥ
     *
     * @access public
     * @param string о
     * @return bool true: 顼̵, false: 顼
     */
    function validate($value)
    {
        $len = strlen($value);

        if ($this->parameters['min'] !== null) {
            if ($len < $this->parameters['min']) {
                if ($this->parameters['min_error'] !== null) {
                    $this->error_message = $this->parameters['min_error'];
                }
                return false;
            }
        }

        if ($this->parameters['max'] !== null) {
            if ($len > $this->parameters['max']) {
                if ($this->parameters['max_error'] !== null) {
                    $this->error_message = $this->parameters['max_error'];
                }
                return false;
            }
        }

        return true;
    }

    /**
     * ʸڽJavaScript
     *
     * @access public
     * @param array եǤradio, select, checkboxξΤߡ
     * @return string JavaScriptå
     */
    function getJsCode($options=array())
    {
        $min = $this->parameters['min'];
        $max = $this->parameters['max'];
        $min_error = $this->parameters['min_error'];
        $max_error = $this->parameters['max_error'];

        $options = array();
        $options[] = "'min': '{$min}'";
        $options[] = "'max': '{$max}'";
        $options[] = "'min_error': '{$min_error}'";
        $options[] = "'max_error': '{$max_error}'";
        $options[] = "'min_valids': '{$this->min_valids}'";
        $options[] = "'max_valids': '{$this->max_valids}'";

        $js  = "";
        $js .= 'if (!error_flag && !validator.isLength(element_name, "' . $this->getErrorMessage() . '", {' . implode(',', $options) . '})) {' . "\n";
        $js .= '  error_flag = true;' . "\n";
        $js .= '}' . "\n";
        return $js;
    }
}

?>
