<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_File.php,v 1.12 2007/06/05 13:08:24 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * magic_quotes_runtime ̵
 */
set_magic_quotes_runtime(0);

/**
 * ե饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_File.php,v 1.12 2007/06/05 13:08:24 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_File
{
    /**
     * ե̾
     * 
     * @access protected
     * @var string
     */
    var $resource_name;
    /**
     * եݥ
     * 
     * @access protected
     * @var resource
     */
    var $fp = null;
    /**
     * ե륪ץ⡼
     * 
     * @access protected
     * @var string
     */
    var $mode;
    /**
     * ѡߥå
     * 
     * @access protected
     * @var int
     */
    var $permission = 0000;
    /**
     * ԥ
     * 
     * @access protected
     * @var string
     */
    var $eol = "\n";
    /**
     * ץ¦Υ󥳡ǥ
     * 
     * @access protected
     * @var string
     */
    var $encode_script = '';
    /**
     * ե¦Υ󥳡ǥ
     * 
     * @access protected
     * @var string
     */
    var $encode_file = '';
    /**
     * ȤΥޥ
     * 
     * @access public
     * @var int
     */
    var $current_umask = null;
    /**
     * CSVեե饰
     * 
     * @access public
     * @var bool
     */
    var $csv = false;
    /**
     * CSVեζڤʸ
     * 
     * @access protected
     * @var string
     */
    var $csv_delimiter = ',';
    /**
     * CSVեΰϤ
     * 
     * @access protected
     * @var string
     */
    var $csv_enclosure = '';

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param string ե̾
     */
    function SyL_File($resource_name)
    {
        $this->resource_name = $resource_name;
    }

    /**
     * SyL_File饹Υ󥹥󥹼
     *
     * @access public
     * @param string ե
     * @param string ե̾
     */
    function &factory($type, $resource_name)
    {
        switch (strtolower($type)) {
        case 'r': $type = 'Reader';   break;
        case 'w': $type = 'Writer';   break;
        case 'a': $type = 'Appender'; break;
        default:  $type = ucfirst($type); break;
        }
        $classname = "SyL_File{$type}";
        include_once dirname(__FILE__) . "/File/{$classname}.php";
        $file =& new $classname($resource_name);
        return $file;
    }

    /**
     * ե򳫤
     *
     * @access public
     * @param string ץ⡼
     */
    function open()
    {
        clearstatcache();

        if ($this->current_umask !== null) {
            $this->current_umask = umask(0000);
        }
        $this->fp = fopen($this->resource_name, $this->mode);
        if (!is_resource($this->fp)) {
            trigger_error("[SyL error] Function fopen failed. file not found or permission denied? ({$this->resource_name})", E_USER_ERROR);
        }
        if ($this->permission) {
            @chmod($this->resource_name, $this->permission);
            $this->permission = 0000;
        }
        //register_shutdown_function(array(&$this, 'close'));
    }

    /**
     * եĤ
     *
     * @access public
     */
    function close()
    {
        if (is_resource($this->fp)) {
            fclose($this->fp);
            $this->fp = null;
        }
        if ($this->permission) {
            @chmod($this->resource_name, $this->permission);
            $this->permission = 0000;
        }
        if ($this->current_umask !== null) {
            umask($this->current_umask);
        }
    }

    /**
     * ե뤫ɤ߹
     *
     * @access public
     * @return string ϥǡ or bool(false) ɤ߹߽λ
     */
    function read() {}

    /**
     * ե˽Ϥ
     *
     * @access public
     * @param string ϥå
     */
    function write($message) {}

    /**
     * ե˽Ϥ˲Ԥղä
     *
     * @access public
     * @param string ϥå
     */
    function writeln($message) {}

    /**
     * CSVեѤ
     *
     * @access public
     */
    function useCsv()
    {
        if (is_resource($this->fp)) {
            trigger_error("[SyL error] `useCsv()' method use before `open()' method", E_USER_ERROR);
        }
        $this->csv = true;
    }

    /**
     * ե륵
     *
     * @access public
     * @return int ե륵
     */
    function getSize()
    {
        return filesize($this->resource_name);
    }

    /**
     * ե˴ؤ
     *
     * @access public
     * @return array ե˴ؤ
     */
    function getStat()
    {
        if (is_resource($this->fp)) {
            return fstat($this->fp);
        } else if (file_exists($this->resource_name)) {
            return stat($this->resource_name);
        } else {
            return false;
        }
    }

    /**
     * ѡߥå򥻥åȤ
     *
     * @access public
     * @param int ѡߥå(8ʿ : 0755)
     */
    function setPermission($permission)
    {
        $this->permission = $permission;
    }

    /**
     * ѤԤ򥻥åȤ
     *
     * @access public
     * @param string 
     */
    function setEol($eol)
    {
        $this->eol = $eol;
    }

    /**
     * ץ¦Υ󥳡ǥ󥰤򥻥åȤ
     *
     * @access public
     * @param string ץ¦Υ󥳡ǥ
     */
    function setScriptEncode($encode_script)
    {
        $this->encode_script = $encode_script;
    }

    /**
     * ե¦Υ󥳡ǥ󥰤򥻥åȤ
     *
     * @access public
     * @param string ե¦Υ󥳡ǥ
     */
    function setFileEncode($encode_file)
    {
        $this->encode_file = $encode_file;
    }

    /**
     * եХåեꤹ
     *
     * @access public
     * @param int եХåե
     */
    function setFileBuffer($buffer)
    {
        if (is_resource($this->fp)) {
            stream_set_write_buffer($this->fp, $buffer);
        }
    }

    /**
     * CSVեζڤʸ򥻥åȤ
     *
     * @access public
     * @param string ڤʸ
     */
    function setCsvDelimiter($csv_delimiter)
    {
        $this->csv_delimiter = $csv_delimiter;
    }

    /**
     * CSVեΰϤҤ򥻥åȤ
     *
     * @access public
     * @param string Ϥ
     */
    function setCsvEnclosure($csv_enclosure)
    {
        $this->csv_enclosure = $csv_enclosure;
    }

    /**
     * ޥͤѤ
     *
     * @access public
     * @param string ޥ
     */
    function useMask($current_umask=0000)
    {
        $this->current_umask = $current_umask;
    }
}

?>
