<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AuthFile.php,v 1.2 2007/04/30 13:15:56 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * եǧڥ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AuthFile.php,v 1.2 2007/04/30 13:15:56 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_AuthFile extends SyL_Auth
{
    /**
     * 桼̾ѥɶڤʸ
     *
     * @access protected
     * @var string
     */
    var $separater = ':';

    /**
     * 󥢥Ƚ
     * 
     * @access public
     * @return bool true: 󥢥󤢤ꡢfalse: 󥢥ʤ
     */
    function isLoginAction()
    {
        return (($_SERVER['REQUEST_METHOD'] == 'POST') && isset($_POST[$this->username]) && isset($_POST[$this->password]));
    }

    /**
     * ǧڼ¹
     * 
     * @access public
     * @return bool OK: ǧOK, NG: ǧNG
     */
    function doLogin()
    {
         $client_username = isset($_POST[$this->username]) ? $_POST[$this->username] : '';
         $client_password = isset($_POST[$this->password]) ? $_POST[$this->password] : '';

         $parameters = explode(':', SYL_AUTH_TYPE_PARAMETER, 2);
         if (!isset($parameters[1])) $parameters[1] = '';

         clearstatcache();

         if (!file_exists($parameters[0])) {
             trigger_error("[SyL error] Auth file not found ({$parameters[0]})", E_USER_ERROR);
         }
         if (!is_readable($parameters[0])) {
             trigger_error("[SyL error] Auth file permission denied ({$parameters[0]})", E_USER_ERROR);
         }

         $find = false;

         $fp = fopen($parameters[0], 'rb');
         while (!feof($fp)) {
             $user = explode($this->separater, rtrim(fgets($fp), "\r\n"));
             if ($user[0] && ($user[0] == $client_username)) {
                 $server_password = isset($user[1]) ? $user[1] : '';
                 $find = true;
                 break;
             }
         }
         fclose($fp);

         if (!$find) {
             // ǧԲ
             $client_username = '';
             $server_password = '';
         }
         // ѥȽ
         return $this->isLoginPassword($client_username, $client_password, $server_password, (bool)$parameters[1]);
    }
}

?>
