<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigActions.php,v 1.22 2007/06/24 10:44:50 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * եɤ߹९饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigActions.php,v 1.22 2007/06/24 10:44:50 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ConfigActions extends SyL_Config
{
    /**
     * ٥̾
     * 
     * @access private
     * @var string
     */
    var $event = 'executeStream';
    /**
     * ƥʥ̾
     * 
     * @access private
     * @var object
     */
    var $action_key = SYL_ACTION_KEY;
    /**
     * ǥեȼ¹Խ
     * 
     * @access private
     * @param int
     */
    var $default_priority = 5;
    /**
     * ǥեȥƥץ졼ȥ
     * 
     * @access private
     * @param string
     */
    var $default_template_type = 'default';
    /**
     * ե륭å奭
     * 
     * @access private
     * @param string
     */
    var $action_cache_key = '__syL_action_cache';
    /**
     * ե륭åǡ
     * 
     * @access private
     * @var array
     */
    var $action_cache_value = array();
    /**
     * ǡ֥
     * 
     * @access private
     * @var object
     */
    var $context = null;

    /**
     * ȥ򥻥å
     * С饤
     *
     * @access public
     * @param object ȥ饪֥
     */
    function setController(&$controller)
    {
        $this->context =& $controller->container->getComponent('context');
    }

    /**
     * XMLեβϽ
     *
     * @access public
     */
    function parseXml()
    {
        if (SYL_CACHE) {
            // åѤ
            $key = $this->context->getActionDir() . $this->context->getActionFile() . $this->context->getActionName();
            $cache =& $this->getCache($key);
            if ($cache) {
                // å夬Ǥʤäʥå奪֥Ȥ
                parent::parseXml();
                // åѥ᡼¸
                $this->config[$this->action_cache_key] = $this->action_cache_value;
                $cache->write($this->config);
            } else {
                // åѥ᡼
                $this->action_cache_value = $this->config[$this->action_cache_key];
            }
            // åѥ᡼
            unset($this->config[$this->action_cache_key]);
        } else {
            // åѤʤ
            parent::parseXml();
        }

        if (!isset($this->config[$this->action_key])) {
            // б륢ޥåԥ󥰤¸ߤʤ
            trigger_error("[SyL error] Action mapping not found (" . $this->context->getActionFile() . ")", E_USER_ERROR);
        }

        // ӥ塼פ򥻥å
        $this->context->setViewType($this->action_cache_value['viewType']);
        // 쥤̾򥻥å
        $this->context->setLayoutName($this->action_cache_value['layout']);
        // ޥӥ塼
        if ($this->action_cache_value['customizedViewFile'] && $this->action_cache_value['customizedViewClass']) {
            $this->context->setCustomizedView($this->action_cache_value['customizedViewClass'], $this->action_cache_value['customizedViewFile']);
        }

        if (isset($this->action_cache_value['template'])) {
            $this->context->setTemplateFile($this->action_cache_value['template']);
        }
    }

    /**
     * XMLǡƼϥɥ᥽å
     * С饤
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        static $name                = '';
        static $pre_name            = '';
        static $post_name           = '';
        static $component_name      = '';
        static $method_name         = '';
        static $prepost_method_name = '';
        static $load                = false;

//echo $current_path . "<br>";
        // 1ɺѤߤξʹߥå
        if ($load) return;

        // XMLϷ̤
        switch ($current_path) {
        case '/syl-actions/action':
            if ($name != '') {
                $name = '';
                $load = true;
                return;
            }
            if (isset($attribute['enable']) && ($attribute['enable'] === 'false')) {
                return;
            }

            // URLǧ
            $reg = isset($attribute['path']) ? str_replace('/', '\\/', $attribute['path']) : '(.*)';
            if (preg_match('/^' . $reg . '$/', $this->context->getActionFile(), $matches)) {
                $name = $this->action_key;
                $this->config[$name]['class']     = $this->context->getClassName();
                $this->config[$name]['type']      = 'action';
                $this->config[$name]['file']      = $this->context->getActionDir() . $this->context->getActionFile();
                $this->config[$name]['reference'] = true;
                // ¹Խ
                $this->config[$name]['priority'] = $this->default_priority;
                // 󥹥ȥ饯󥸥ե饰
                $this->config[$name]['constructor'] = false;
                // ե뤬¸ߤʤȥ顼Υե饰
                $this->config[$name]['force'] = (SYL_ENV_TYPE == 'cmd'); // ޥɥ饤Τߥե¸ߥå
                // ٥ȥʥ֥Ⱥ
                $this->config[$name]['event'][$this->event][] = $name;
                // 
                $this->config[$name]['args'] = array();
                // ӥ塼
                $this->action_cache_value['viewType'] = isset($attribute['viewType']) ? $attribute['viewType'] : '';
                // 쥤
                $this->action_cache_value['layout'] = isset($attribute['layout']) ? $attribute['layout'] : '';
                // ޥӥ塼
                $this->action_cache_value['customizedViewFile']  = isset($attribute['customizedViewFile'])  ? $attribute['customizedViewFile']  : '';
                $this->action_cache_value['customizedViewClass'] = isset($attribute['customizedViewClass']) ? $attribute['customizedViewClass'] : '';

                // ̥
                if (isset($attribute['commonPreAction']) && $attribute['commonPreAction']) {
                    $pre_name = 'commonPreAction';
                    $this->config[$pre_name]['class']       = $attribute['commonPreAction'];
                    $this->config[$pre_name]['type']        = 'action';
                    $this->config[$pre_name]['file']        = SYL_APP_DIR . '/' .  $attribute['commonPreAction'] . '.php';
                    $this->config[$pre_name]['reference']   = true;
                    $this->config[$pre_name]['priority']    = $this->default_priority - 1; // ¹Խ(1ʳᤤ)
                    $this->config[$pre_name]['constructor'] = false;
                    $this->config[$pre_name]['force']       = false;
                    $this->config[$pre_name]['event'][$this->event][] = $pre_name;
                    $this->config[$pre_name]['args'] = array();
                }

                // ̥
                if (isset($attribute['commonPostAction']) && $attribute['commonPostAction']) {
                    $post_name = 'commonPostAction';
                    $this->config[$post_name]['class']       = $attribute['commonPostAction'];
                    $this->config[$post_name]['type']        = 'action';
                    $this->config[$post_name]['file']        = SYL_APP_DIR . '/' .  $attribute['commonPostAction'] . '.php';
                    $this->config[$post_name]['reference']   = true;
                    $this->config[$post_name]['priority']    = $this->default_priority + 1; // ¹Խ(1ʳ٤)
                    $this->config[$post_name]['constructor'] = false;
                    $this->config[$post_name]['force']       = false;
                    $this->config[$post_name]['event'][$this->event][] = $post_name;
                    $this->config[$post_name]['args'] = array();
                }

                // ǥեȥƥץ졼ȼ
                if ((SYL_ENV_TYPE == 'web') && isset($attribute['template'])) {
                    $template = $attribute['template'];
                    for ($i=0; $i<count($matches); $i++) {
                        $template = str_replace("\${$i}", $matches[$i], $template);
                    }
                    $this->action_cache_value['template'] = $template;
                }
            }
            break;

        default:
            if (!$name) return;

            switch ($current_path) {
            case '/syl-actions/action/setter':
                // 쥯ȥåȥ
                if (isset($attribute['direct']) && ($attribute['direct'] === 'true')) {
                    $method_name = 'setter:' . $attribute['name'] . ':true';
                } else {
                    $method_name = 'setter:set' . ucfirst($attribute['name']) . ':false';
                }
                $prepost_method_name = '';
                $this->config[$name]['event'][$this->event][] = $method_name;
                $this->config[$name]['args'][$method_name]    = array();
                break;

            case '/syl-actions/action/method':
                $method_name         = 'method:' . str_replace('{$action}', $this->context->getActionName(), $attribute['name']);
                $prepost_method_name = 'method:' . str_replace('{$action}', '', $attribute['name']);
                $this->config[$name]['args'][$method_name] = array();
                $this->config[$name]['event'][$this->event][] = $method_name; // ٥ȥ
                if ($pre_name) {
                    $this->config[$pre_name]['args'][$prepost_method_name] = array();
                    $this->config[$pre_name]['event'][$this->event][]      = $prepost_method_name; // ٥ȥ
                }
                if ($post_name) {
                    $this->config[$post_name]['args'][$prepost_method_name] = array();
                    $this->config[$post_name]['event'][$this->event][]      = $prepost_method_name; // ٥ȥ
                }
                break;

            case '/syl-actions/action/setter/arg':
            case '/syl-actions/action/method/arg':
                $type = isset($attribute['type']) ? $attribute['type'] : 'value';
                $ref  = (isset($attribute['reference']) && ($attribute['reference'] === 'true')) ? 'true' : 'false';
                $arg  = "{$type}:{$ref}:{$text}";
                $this->config[$name]['args'][$method_name][] = $arg;
                if ($prepost_method_name) {
                    if ($pre_name) {
                        $this->config[$pre_name]['args'][$prepost_method_name][] = $arg;
                    }
                    if ($post_name) {
                        $this->config[$post_name]['args'][$prepost_method_name][] = $arg;
                    }
                }
                break;

           case '/syl-actions/action/components/component':
                if (isset($attribute['enable']) && ($attribute['enable'] === 'false')) {
                    $component_name = '';
                    return;
                }
                $component_name = $attribute['name'];
                $this->config[$component_name]['type']      = 'component';
                $this->config[$component_name]['class']     = isset($attribute['class'])  ? $attribute['class'] : $component_name;
                $this->config[$component_name]['file']      = $attribute['file'];
                $this->config[$component_name]['reference'] = (isset($attribute['reference']) && ($attribute['reference'] === 'true'));
                // ¹Խ(2ʳᤤ)
                $default_priority = $this->default_priority - 2;
                $component_priority = isset($attribute['priority']) ? floatval($default_priority . '.' . $attribute['priority']) : $default_priority;
                $this->config[$component_name]['priority'] = $component_priority;
                // 󥹥ȥ饯󥸥ե饰
                $this->config[$component_name]['constructor'] = false;
                // ե뤬¸ߤʤȥ顼Υե饰
                $this->config[$component_name]['force'] = false;
                // ٥ȥ
                $this->config[$component_name]['event'][$this->event][] = $component_name;
                // 
                $this->config[$component_name]['args'] = array();
                break;

            default:
                if (!$component_name) return;

                switch ($current_path) {
                case '/syl-actions/action/components/component/constructor':
                    $method_name = 'constructor:' . (isset($attribute['static']) ? $attribute['static'] : '');
                    // 󥹥ȥ饯󥸥ե饰
                    $this->config[$component_name]['constructor'] = true;
                    // 󥹥ȥ饯󥸥ξ硢Υ᥽åɤϺ
                    $index = array_search($component_name, $this->config[$component_name]['event'][$this->event]);
                    if ($index !== false) {
                        unset($this->config[$component_name]['event'][$this->event][$index]);
                    }
                    $this->config[$component_name]['event'][$this->event][] = $method_name;
                    $this->config[$component_name]['args'][$method_name] = array();
                    break;

                case '/syl-actions/action/components/component/setter':
                    // 쥯ȥåȥ
                    if (isset($attribute['direct']) && ($attribute['direct'] === 'true')) {
                        $method_name = 'setter:' . $attribute['name'] . ':true';
                    } else {
                        $method_name = 'setter:set' . ucfirst(strtolower($attribute['name'])) . ':false';
                    }
                    $this->config[$component_name]['event'][$this->event][] = $method_name;
                    $this->config[$component_name]['args'][$method_name] = array();
                    break;

                case '/syl-actions/action/components/component/method':
                    $method_name = 'method:' . $attribute['name'];
                    $this->config[$component_name]['event'][$this->event][] = $method_name;
                    $this->config[$component_name]['args'][$method_name] = array();
                    break;

                case '/syl-actions/action/components/component/setter/arg':
                case '/syl-actions/action/components/component/constructor/arg':
                case '/syl-actions/action/components/component/method/arg':
                    $type = isset($attribute['type']) ? $attribute['type'] : 'value';
                    $ref  = (isset($attribute['reference']) && ($attribute['reference'] === 'true')) ? 'true' : 'false';
                    $this->config[$component_name]['args'][$method_name][] = $type . ':' . $ref . ':' . $text;
                    break;
                }
            }
        }
    }
}

?>
