<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigFilters.php,v 1.17 2007/05/20 09:43:02 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ե륿եɤ߹९饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigFilters.php,v 1.17 2007/05/20 09:43:02 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ConfigFilters extends SyL_Config
{
    /**
     * ٥̾
     * 
     * @access private
     * @var string
     */
    var $event = 'loadStream';
    /**
     * ե륿٥ȡʥ
     * 
     * @access private
     * @var string
     */
    var $filter_event_pre_action = 'executeStream';
    /**
     * ե륿٥ȡʥ
     * 
     * @access private
     * @var string
     */
    var $filter_event_post_action = 'middleStream';
    /**
     * ե륿٥ȡʥӥ塼ɽ
     * 
     * @access private
     * @var string
     */
    var $filter_event_pre_render = 'renderStream';
    /**
     * ե륿٥ȡʥӥ塼ɽ
     * 
     * @access private
     * @var string
     */
    var $filter_event_post_render = 'unloadStream';
    /**
     * ǥեȼ¹Խ
     * 
     * @param int
     */
    var $default_priority = 2;
    /**
     * ե̾
     * 
     * @access private
     * @var string
     */
    var $action_file = '';

    /**
     * ȥ򥻥å
     * С饤
     *
     * @access public
     * @param object ȥ饪֥
     */
    function setController(&$controller)
    {
        $context =& $controller->container->getComponent('context');
        $this->action_file = $context->getActionFile();
    }

    /**
     * XMLեβϽ
     *
     * @access public
     */
    function parseXml()
    {
        if (SYL_CACHE) {
            // åѤ
            $key = SYL_APP_DIR . $this->action_file;
            $cache =& $this->getCache($key);
            if ($cache) {
                // å夬Ǥʤäʥå奪֥Ȥ
                parent::parseXml();
                $cache->write($this->config);
            }
        } else {
            // åѤʤ
            parent::parseXml();
        }
    }

    /**
     * XMLǡƼϥɥ᥽å
     * С饤
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        static $name  = '';
        static $method_name = '';

//echo $current_path . "<br>";

        // XMLϷ̤
        switch ($current_path) {
        case '/syl-filters/filter':
            if (isset($attribute['enable']) && ($attribute['enable'] === 'false')) {
                $name = '';
                return;
            }

            // ̾ǧ
            $reg = isset($attribute['path']) ? str_replace('/', '\\/', $attribute['path']) : '(.*)';
            if (preg_match('/^' . $reg . '$/', $this->action_file)) {
                $name = '__filter_' . $attribute['name'];
                $this->config[$name]['type']      = 'filter';
                $this->config[$name]['class']     = $attribute['class'];
                $this->config[$name]['file']      = $attribute['file'];
                $this->config[$name]['reference'] = false;
                // ¹Խ
                $this->config[$name]['priority'] = $this->default_priority;
                // 󥹥ȥ饯󥸥ե饰
                $this->config[$name]['constructor'] = false;
                // ե뤬¸ߤʤȥ顼Υե饰
                $this->config[$name]['force'] = false;
                // ٥ȥʥ֥Ⱥ
                $this->config[$name]['event'][$this->event][] = $name;
                // 
                $this->config[$name]['args'] = array();
            } else {
                $name = '';
            }
            break;

        default:
            if (!$name) return;

            switch ($current_path) {
            case '/syl-filters/filter/preAction':
               $method_name = 'method:' . (isset($attribute['name']) ? $attribute['name'] : 'preAction');
               $this->config[$name]['event'][$this->filter_event_pre_action][] = $method_name;
               $this->config[$name]['args'][$method_name] = array();
               break;

            case '/syl-filters/filter/postAction':
               $method_name = 'method:' . (isset($attribute['name']) ? $attribute['name'] : 'postAction');
               $this->config[$name]['event'][$this->filter_event_post_action][] = $method_name;
               $this->config[$name]['args'][$method_name] = array();
               break;

            case '/syl-filters/filter/preRender':
               $method_name = 'method:' . (isset($attribute['name']) ? $attribute['name'] : 'preRender');
               $this->config[$name]['event'][$this->filter_event_pre_render][] = $method_name;
               $this->config[$name]['args'][$method_name]  = array();
               break;

            case '/syl-filters/filter/postRender':
               $method_name = 'method:' . (isset($attribute['name']) ? $attribute['name'] : 'postRender');
               $this->config[$name]['event'][$this->filter_event_post_render][] = $method_name;
               $this->config[$name]['args'][$method_name]  = array();
               break;

            case '/syl-filters/filter/preAction/arg':
            case '/syl-filters/filter/postAction/arg':
            case '/syl-filters/filter/preRender/arg':
            case '/syl-filters/filter/postRender/arg':
               $type = isset($attribute['type']) ? $attribute['type'] : 'value';
               $ref  = (isset($attribute['reference']) && ($attribute['reference'] === 'true')) ? 'true' : 'false';
               $this->config[$name]['args'][$method_name][] = "{$type}:{$ref}:{$text}";
               break;
            }
        }
    }
}

?>
