<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigLayouts.php,v 1.9 2007/06/24 10:44:50 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 쥤եɤ߹९饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigLayouts.php,v 1.9 2007/06/24 10:44:50 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ConfigLayouts extends SyL_Config
{
    /**
     * оݥ쥤̾
     * 
     * @access private
     * @var string
     */
    var $layout_name = '';

    /**
     * ȥ򥻥å
     * С饤
     *
     * @access public
     * @param object ȥ饪֥
     */
    function setController(&$controller)
    {
        $context =& $controller->container->getComponent('context');
        $this->layout_name = $context->getLayoutName();
        if (!$this->layout_name) {
            trigger_error("[SyL error] Invalid layout name ({$this->layout_name})", E_USER_ERROR);
        }
    }

    /**
     * XMLեβϽ
     *
     * @access public
     */
    function parseXml()
    {
        if (SYL_CACHE) {
            // åѤ
            $key = SYL_APP_DIR . $this->layout_name;
            $cache =& $this->getCache($key);
            if ($cache) {
                // å夬Ǥʤäʥå奪֥Ȥ
                parent::parseXml();
                $cache->write($this->config);
            }
        } else {
            // åѤʤ
            parent::parseXml();
        }

        if (!isset($this->config['file'])) {
            // б쥤ȥޥåԥ󥰤¸ߤʤ
            trigger_error("[SyL error] Layout mapping not found (Layout name: " . $this->layout_name . ")", E_USER_ERROR);
        }
    }

    /**
     * XMLǡƼϥɥ᥽å
     * С饤
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        static $layout = false;
        static $load   = false;

//echo $current_path . "<br>";
        // 1ɺѤߤξʹߥå
        if ($load) return;

        // XMLϷ̤
        switch ($current_path) {
        case '/syl-layouts/layout':
            if ($layout) {
                $load = true;
                return;
            }
            if (isset($attribute['enable']) && ($attribute['enable'] === 'false')) {
                return;
            }

            // 쥤̾Ƚ
            if ($attribute['name'] == $this->layout_name) {
                $layout = true;
                $this->config['file']       = $attribute['file'];
                $this->config['templates']  = array();
                $this->config['content']    = array();
                $this->config['parameters'] = array();
            }
            break;

        default:
            if (!$layout) return;

            switch ($current_path) {
            case '/syl-layouts/layout/template':
               $this->config['templates'][$attribute['name']] = $attribute['file'];
               break;

            case '/syl-layouts/layout/content':
                $this->config['content'] = $attribute['name'];
               break;

            case '/syl-layouts/layout/parameters/parameter':
               $this->config['parameters'][$attribute['name']] = $attribute['value'];
               break;
            }
        }
    }
}

?>
