<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FormElementGroup.php,v 1.3 2007/04/30 13:15:56 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * եǥ롼ץ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FormElementGroup.php,v 1.3 2007/04/30 13:15:56 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_FormElementGroup extends SyL_FormElement
{
    /**
     * ե
     *
     * @access private
     * @var array
     */
    var $elements = array();
    /**
     * ɽեޥå
     *
     * @access private
     * @var string
     */
    var $format = null;
    /**
     * եޥåɽ
     *
     * @access private
     * @var array
     */
    var $format_names = array();

    /**
     * ե४֥Ȥ򥻥åȤ
     *
     * @access public
     * @param object ե४֥
     */
    function initGroup(&$form)
    {
    }

    /**
     * եǥ֥Ȥɲä
     *
     * @access public
     * @param object եǥ֥
     */
    function addElement(&$element)
    {
        // ǥ֥ȳǼ
        $this->elements[$element->getName()] =& $element;
    }

    /**
     * ɽեޥåȤ򥻥åȤ
     *
     * @access public
     * @param string ɽեޥå
     */
    function setFormat($format)
    {
        $this->format = $format;
        $this->format_names = array_slice(func_get_args(), 1);
    }

    /**
     * ͤ
     *
     * @access public
     * @return string ̾
     */
    function getValue()
    {
        $values = array();
        foreach (array_keys($this->elements) as $name) {
            $values[$name] = $this->elements[$name]->getValue();
        }
        return $values;
    }

    /**
     * ͤ򥻥åȤ
     *
     * @access public
     * @param mixed 
     */
    function setValue($value)
    {
        if (is_array($value)) {
            foreach ($value as $name => $value) {
                if (isset($this->elements[$name])) {
                    $this->elements[$name]->setValue($value);
                }
            }
        }
    }

    /**
     * եɽȽե饰򥻥å
     *
     * @access public
     * @param bool եɽȽե饰
     */
    function setReadOnly($read_only)
    {
        foreach (array_keys($this->elements) as $name) {
            $values[$name] = $this->elements[$name]->setReadOnly($read_only);
        }
        parent::setReadOnly($read_only);
    }

    /**
     * ɬܥå¸Ƚ
     * ڥ롼ץ֥Ȥ򥻥åȤƤ¹Ԥ
     *
     * @access public
     * @return bool true: ɬܥåꡢfalse: ɬܥå̵
     */
    function isRequire()
    {
        $is = false;
        foreach (array_keys($this->elements) as $name) {
            if ($this->elements[$name]->isRequire()) {
                $is = true;
                break;
            }
        }
        return $is;
    }

    /**
     * եHTMLϡϹܡ
     *
     * @access public
     * @return string եǤHTML
     */
    function getHtmlTag()
    {
        $htmls = array();
        if ($this->format) {
            $htmls[] = $this->format;
            foreach ($this->format_names as $name) {
                $htmls[] = $this->elements[$name]->getHtmlTag();
            }
            return call_user_func_array('sprintf', $htmls);
        } else {
            foreach ($this->elements as $element) {
                $htmls[] = $element->getHtmlTag();
            }
            return implode('', $htmls);
        }
    }

    /**
     * եHTMLϡɽ
     *
     * @access public
     * @return string եǤHTML
     */
    function getHtmlView()
    {
        $htmls = array();
        if ($this->format) {
            $htmls[] = $this->format;
            foreach ($this->format_names as $name) {
                $htmls[] = $this->elements[$name]->getHtmlView();
            }
            return call_user_func_array('sprintf', $htmls);
        } else {
            foreach ($this->elements as $element) {
                $htmls[] = $element->getHtmlView();
            }
            return implode('', $htmls);
        }
    }

    /**
     * ڥ롼ץ֥Ȥ򥻥å
     *
     * @access public
     * @param object ڥ롼ץ֥
     */
    function setValidators(&$validators)
    {
        foreach (array_keys($this->elements) as $name) {
            $this->elements[$name]->setValidators($validators);
        }
    }

    /**
     * ڤ¹Ԥ
     * ڥ롼ץ֥Ȥʤϡtrue
     *
     * @access public
     * @return bool true: 顼̵false: 顼
     */
    function validate()
    {
        foreach (array_keys($this->elements) as $name) {
            if (!$this->elements[$name]->validate()) {
                $this->error_message = $this->elements[$name]->getErrorMessage();
                return false;
            }
        }
        return true;
    }

    /**
     * JavaScriptϥå
     *
     * @access public
     * @return string JavaScriptϥå
     */
    function getJs($formname)
    {
        $js     = '';
        $error_confirm = array();
        foreach (array_keys($this->elements) as $name) {
            $tmp     = $this->elements[$name]->getJs($formname);
            $element = $this->elements[$name]->getNames();
            if (count($tmp) == 2) {
                if (count($error_confirm) > 0) {
                    $js .= 'if (' . implode(' && ', $error_confirm) . ') {' . "\n";
                    $js .= $tmp[1] . "\n";
                    $js .= $tmp[0] . ';' . "\n";
                    $js .= '}' . "\n";
                } else {
                    $js .= $tmp[1] . "\n";
                    $js .= $tmp[0] . ';' . "\n";
                }
            }
            $error_confirm[] = "!errors.isError('{$element}')";
        }

        if ($js) {
            $element = $this->getName();
            $func    = "check_{$formname}_{$element}(form, errors)";
            $js   = <<< JAVASCRIPT_CODE
function {$func}
{
  var validation    = new SyL_Validation(form);
  var error_message = "";

{$js}

  if (error_message) {
    switch (typeof(errors)) {
    case 'object':
      errors.setErrorMessage(element_name, error_message);
      break;
    case 'string':
      document.getElementById(errors).innerHTML = error_message;
      break;
    }
  }
}

JAVASCRIPT_CODE;
            return array($func, $js);
        } else {
            return array();
        }
    }
}

?>
