<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilUseragent.php,v 1.1 2007/06/24 10:44:50 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * [U[G[WFgNX
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilUseragent.php,v 1.1 2007/06/24 10:44:50 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_UtilUseragent
{
    /**
     * [U[G[WFg
     *
     * @access private
     * @var string
     */
    var $user_agent = '';

    /**
     * vbgtH[iOSjzi}X^j
     *
     * @access private
     * @var array
     */
    var $platforms = array(
      'windows nt 6.0'  => 'Windows Vista',
      'windows nt 5.2'  => 'Windows 2003 or XP x64',
      'windows nt 5.1'  => 'Windows XP',
      'windows nt 5.01' => 'Windows 2000 (Service Pack 1)',
      'windows nt 5.0'  => 'Windows 2000',
      'windows nt 4.0'  => 'Windows NT 4.0',
      'winnt4.0'        => 'Windows NT 4.0',
      'winnt 4.0'       => 'Windows NT',
      'winnt'           => 'Windows NT',
      'windows 98'      => 'Windows 98',
      'win98'           => 'Windows 98',
      'windows 95'      => 'Windows 95',
      'win95'           => 'Windows 95',
      'windows ce'      => 'Windows CE',
      'windows'         => 'Unknown Windows OS',
      'os x'            => 'Mac OS X',
      'ppc mac'         => 'Power PC Mac',
      'freebsd'         => 'FreeBSD',
      'debian'          => 'Debian',
      'sunos'           => 'Sun Solaris',
      'beos'            => 'BeOS',
      'aix'             => 'AIX',
      'irix'            => 'Irix',
      'hp-ux'           => 'HP-UX',
      'netbsd'          => 'NetBSD',
      'openbsd'         => 'OpenBSD',
      'gnu'             => 'GNU/Linux',
      'linux'           => 'Linux',
      'unix'            => 'Unknown Unix OS'
    );

    /**
     * uEUzi}X^j
     *
     * @access private
     * @var array
     */
    var $browsers = array(
      'Opera'             => 'Opera',
      'Lunascape'         => 'Lunascape',
      'Sleipnir'          => 'Sleipnir',
      'MSIE'              => 'Internet Explorer',
      'Internet Explorer' => 'Internet Explorer',
      'Shiira'            => 'Shiira',
      'Firefox'           => 'Firefox',
      'Firebird'          => 'Firebird',
      'Chimera'           => 'Chimera',
      'Phoenix'           => 'Phoenix',
      'Camino'            => 'Camino',
      'Netscape'          => 'Netscape',
      'Safari'            => 'Safari',
      'IBrowse'           => 'IBrowse',
      'icab'              => 'iCab',
      'Konqueror'         => 'Konqueror',
      'hotjava'           => 'HotJava',
      'Lynx'              => 'Lynx',
      'NetFront'          => 'NetFront',
      'OmniWeb'           => 'OmniWeb',
      'Mozilla'           => 'Mozilla',
      'W3C'               => 'W3C Validator',
      'Wget'              => 'Wget'
    );

    /**
     * oCLAzi}X^j
     *
     * @access private
     * @var array
     */
    var $carriers = array(
      'DoCoMo'     => 'DoCoMo',
      'UP.Browser' => 'KDDI(au)',
      'KDDI-'      => 'KDDI(au)',
      'J-PHONE'    => 'SoftBank',
      'Vodafone'   => 'SoftBank',
      'SoftBank'   => 'SoftBank',
      'WILLCOM'    => 'WILLCOM',
      'DDIPOCKET'  => 'WILLCOM',
      'PDXGW'      => 'WILLCOM',
      'L-mode'     => 'NTT(L-mode)'
    );

    /**
     * RXgN^
     *
     * @access public
     * @param string [U[G[WFg
     */
    function SyL_UtilUseragent($user_agent='')
    {
        if ($user_agent) {
            $this->user_agent = $user_agent;
        } else {
            $this->user_agent = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : '';
        }
    }

    /**
     * oCs
     *
     * @access public
     * @return bool true: oCAfalse: oCȊO
     */
    function isMobile()
    {
        return ($this->getCarrier() !== null);
    }

    /**
     * vbgtH[iOSj擾
     *
     * @access public
     * @return string vbgtH[iOSj
     */
    function getPlatform()
    {
        foreach ($this->platforms as $key => $value) {
            if (stristr($this->user_agent, $key) !== false) {
                return $value;
            }
        }
        return null;
    }

    /**
     * uEU擾
     *
     * @access public
     * @return string uEU
     */
    function getBrowser()
    {
        foreach ($this->browsers as $key => $value) {
            if (preg_match('/' . preg_quote($key, '/') . '.*([0-9\.]+)?/i', $this->user_agent, $matches)) {
                return isset($matches[1]) ? $value . ' ' . $matches[1] : $value;
            }
        }
        return null;
    }

    /**
     * LA擾
     *
     * @access public
     * @return string LA
     */
    function getCarrier()
    {
        foreach ($this->carriers as $key => $value) {
            if (stristr($this->user_agent, $key) !== false) {
                return $value;
            }
        }
        return null;
    }

    /**
     * oC̋@햼擾
     *
     * @access public
     * @return string oC̋@햼
     */
    function getMobileModel()
    {
        switch ($this->getCarrier()) {
        case 'DoCoMo':
            // jDoCoMo/1.0/D505i/c20/TB/W20H10/serNMAIA000001
            if (preg_match('/^DoCoMo\/\d\.0\/([^\/]+)\/(.*)$/i', $this->user_agent, $matches)) {
                return $matches[1];
            // jDoCoMo/2.0 F900i(c100;TC;W22H12)
            } else if (preg_match('/^DoCoMo\/\d\.0[ ]*([^\(]+)(.*)$/i', $this->user_agent, $matches)) {
                return $matches[1];
            }
            break;
        case 'KDDI(au)':
            // jKDDI-HI32 UP.Browser/6.2.0.6.2 (GUI) MMP/2.0
            //     UP.Browser/3.04-ST13 UP.Link/3.4.5.9
            if (preg_match('/^([^\-]+)\-(.+) (.+)$/i', $this->user_agent, $matches)) {
                return $matches[2];
            }
            break;
        case 'SoftBank':
            if (isset($_SERVER['HTTP_X_JPHONE_MSNAME'])) {
                return $_SERVER['HTTP_X_JPHONE_MSNAME'];
            // jSoftBank/1.0/910T/TJ001/SN*** Browser/NetFront/3.3 Profile/MIDP-2.0 Configuration/CLDC-1.1
            } else if (preg_match('/^([^\/]+)\/([^\/]+)\/([^\/]+)\/(.+)$/i', $this->user_agent, $matches)) {
                return $matches[3];
            }
            break;
        case 'WILLCOM':
            // jMozilla/4.0 (compatible; MSIE 4.01; Windows CE; SHARP/WS003SH; PPC; 480x640)
            if (preg_match('/^Mozilla\/\d\.0\([^\/]+)\/([^;]+);(.*)$/i', $this->user_agent, $matches)) {
                return $matches[2];
            // jMozilla/3.0(WILLCOM;SANYO/WX310SA/2;1/1/C128) NetFront/3.3
            } else if (preg_match('/^Mozilla\/\d\.0\([^\/]+)\/([^\/]+)\/(.*)$/i', $this->user_agent, $matches)) {
                return $matches[2];
            }
            break;
        }
        return null;
    }
}

?>
