<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidationValidator.php,v 1.4 2007/04/30 13:15:57 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ڸ̥饹
 * 
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidationValidator.php,v 1.4 2007/04/30 13:15:57 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ValidationValidator extends SyL_Validation
{
    /**
     * ڥ
     *
     * @access protected
     * @var string
     */
    var $type = '';
    /**
     * ѥ᡼
     *
     * @access protected
     * @var array
     */
    var $parameters = array();
    /**
     * ѥ᡼κ㸡OK
     *  0 ϥѥ᡼
     *
     * @access protected
     * @var int
     */
    var $min_valids = 0;
    /**
     * ѥ᡼κ縡OK
     *  0 ϥѥ᡼
     *
     * @access protected
     * @var int
     */
    var $max_valids = 0;

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param string Хǡ
     * @param string 顼åΥեޥå
     * @param array ڥѥ᡼
     */
    function SyL_ValidationValidator($type, $error_message, $parameters=array())
    {
        $this->type          = $type;
        $this->error_message = $error_message;
        $this->parameters    = array_merge($this->parameters, $parameters);
    }

    /**
     * ̸ڥ֥Ȥμ
     *
     * @static
     * @access public
     * @param string ̾
     * @param string 顼å
     * @param array ڥѥ᡼
     * @return object ̸ڥ֥
     */
    function &create($type, $error_message, $parameters=array())
    {
        $classname =  'SyL_ValidationValidator' . ucfirst($type);
        include_once dirname(__FILE__) . "/Validator/{$classname}.php";
        $obj =& new $classname($type, $error_message, $parameters);
        return $obj;
    }

    /**
     * ڥѥ᡼򥻥å
     *
     * @access public
     * @param array ڥѥ᡼
     */
    function setParameters($parameters)
    {
        $this->parameters = array_merge($this->parameters, $parameters);
    }

    /**
     * 㸡OK򥻥å
     *
     * @access public
     * @param int 㸡OK
     */
    function setMinValids($min_valids)
    {
        $this->min_valids = $min_valids;
    }

    /**
     * 縡OK򥻥å
     *
     * @access public
     * @param int 縡OK
     */
    function setMaxValids($max_valids)
    {
        $this->max_valids = $max_valids;
    }

    /**
     * ¨ڽ¹Ԥ
     *
     * @static
     * @access public
     * @param string ̾
     * @param string о
     * @param array ڥѥ᡼
     * @return bool true: 顼̵, false: 顼
     */
    function executeImmediate($validate_name, $value, $parameters=array())
    {
        $validator =& SyL_ValidationValidator::create($validate_name, '', $parameters);
        return $validator->execute($value);
    }

    /**
     * ڽ¹Ԥ
     *
     * @access public
     * @param string о
     * @param string о̾
     * @return bool true: 顼̵, false: 顼
     */
    function execute($value, $name='')
    {
        if (is_array($value)) {
            if (count($value) == 0) {
                if ($this->isRequire()) {
                    $this->replaceErrorMessage($name);
                    return false;
                } else {
                    return true;
                }
            } else {
                $ok = 0;
                foreach ($value as $tmp) {
                    if ($this->execute($tmp, $name)) {
                        $ok++;
                    }
                }
                if ($this->max_valids == 0) {
                    $this->max_valids = count($value);
                    if ($this->min_valids == 0) {
                        $this->min_valids = count($value);
                    }
                }
                if (($this->max_valids < $ok) || ($this->min_valids > $ok)) {
                    $this->replaceErrorMessage($name);
                    return false;
                } else {
                    return true;
                }
            }
        } else {
            // ɬܥå or եåʳǡͤξtrue
            if (!$this->isRequire()) {
                if (!call_user_func(array(__CLASS__, 'executeImmediate'), 'require', $value)) {
                    return true;
                }
            }

            if (!$this->validate($value)) {
                $this->replaceErrorMessage($name);
                return false;
            } else {
                return true;
            }
        }
    }

    /**
     * ڽ¹Ԥ
     *
     * @access public
     * @param mixed о
     * @return bool true: 顼̵, false: 顼
     */
    function validate($value)
    {
    }

    /**
     * 顼å
     *
     * @access public
     * @param string ̾
     */
    function replaceErrorMessage($name)
    {
        foreach ($this->parameters as $key => $value) {
            if (is_scalar($value)) {
                $search = array('{' . $key . '}', '%' . $key . '%');
                $this->error_message = str_replace($search, $value, $this->error_message);
            }
        }
        $this->error_message = str_replace(array('{min_valids}', '%min_valids%'), $this->min_valids, $this->error_message);
        $this->error_message = str_replace(array('{max_valids}', '%max_valids%'), $this->max_valids, $this->error_message);

        parent::replaceErrorMessage($name);
    }

    /**
     * ڽJavaScript
     *
     * @access public
     * @param string եɽ̾
     * @param array եǤradio, select, checkboxξΤߡ
     * @return string JavaScriptå
     */
    function getJs($display_name)
    {
        $this->replaceErrorMessage($display_name);
        return $this->getJsCode();
    }

    /**
     * ڽJavaScript
     *
     * @access public
     * @param array եǤradio, select, checkboxξΤߡ
     * @return string JavaScriptå
     */
    function getJsCode()
    {
        return '';
    }
}

/**
 * ꥢ
 */
class SyL_Validator extends SyL_ValidationValidator{}

?>
