<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_RequestSession.php,v 1.12 2007/06/05 13:08:24 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * åݻ饹
 * 
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_RequestSession.php,v 1.12 2007/06/05 13:08:24 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_RequestSession extends SyL_UtilProperty
{
    /**
     * åURLѥ
     *
     * @access private
     * @var string
     */
    var $path = '';
    /**
     * å󳫻ϥե饰
     *
     * @access private
     * @var bool
     */
    var $start = false;

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_RequestSession()
    {
        if (!$this->start) {
            // å̾򥻥å
            if (SYL_SESSION_NAME) {
                session_name(SYL_SESSION_NAME);
            }
            // åѹ
            if (SYL_SESSION_CACHE) {
                session_cache_limiter(SYL_SESSION_CACHE);
            }
            // åƼѥ᡼
            list($this->path, $session_domain, $session_secure) = explode(':', SYL_SESSION_COOKIE_PARAMS, 3);
            if (!$this->path) $this->path = '/';
            if (!$session_domain) $session_domain = null;
            $session_secure = (bool)$session_secure;
            session_set_cookie_params(0, $this->path, $session_domain, $session_secure);
            // å¸ѥ
            $this->setSavePath();

            // å󳫻
            $this->startSession();
            // åIDѹ
            if (SYL_SESSION_REGENERATE) {
                $this->regenerateSession();
            }
        }
    }

    /**
     * å¸ѥ
     *
     * @access protected
     */
    function setSavePath()
    {
        if (SYL_SESSION_SAVE_PATH) {
            session_save_path(SYL_SESSION_SAVE_PATH);
        }
    }

    /**
     * å򳫻Ϥ
     *
     * @access public
     * @param array 쥻åΥǡ
     */
    function startSession($old_session_data=null)
    {
        if (!$this->start) {
            session_start();
            $this->start = true;
            if (is_array($old_session_data)) {
                $_SESSION = $old_session_data;
            }
            $this->parameters =& $_SESSION;
        }
    }

    /**
     * å󤬳ϤƤ뤫Ƚ
     *
     * @access public
     * @return true: ϤƤ롢false: ϤƤʤ
     */
    function isSession()
    {
        return $this->start;
    }

    /**
     * åIDѹ
     * å󳫻ϸ˼¹Ԥ
     *
     * @access public
     */
    function regenerateSession()
    {
        if (version_compare(PHP_VERSION, '5.1.0', '>=')) {
            session_regenerate_id(true);
        } else {
            $old_session_id   = $this->getSessionId();
            $old_session_data = $this->parameters;
            $_SESSION = array();
            session_destroy();
            $this->start = false;

            $session_dir = session_save_path();
            $new_session_id = '';
            do {
              $new_session_id = md5(uniqid(rand(), true));
            } while (file_exists("{$session_dir}/sess_{$new_session_id}"));
            session_id($new_session_id);

            $this->startSession($old_session_data);
        }
    }

    /**
     * ѥ᡼
     * 
     * @access public
     */
    function deletes()
    {
        parent::deletes();
        if (isset($_COOKIE[session_name()])) {
           setcookie(session_name(), '', time()-42000, $this->path);
        }
        session_destroy();
        $this->start = false;
    }

    /**
     * åͤ¸λ
     * 
     * @access public
     * @param array ѥ᡼
     */
    function writeCloseSession($values)
    {
        $this->startSession();
        parent::sets($values);
        $this->closeSession();
    }

    /**
     * åλ
     * 
     * @access public
     */
    function closeSession()
    {
        if ($this->start) {
            session_write_close();
            $this->start = false;
            parent::deletes();

            // 2ܰʹߤsession_start()ǥåȯԤʤб
            if (ini_get('session.use_cookies')) {
              ini_set('session.use_cookies', '0');
            }
        }
    }

    /**
     * åID
     * 
     * @access public
     * @return mixed åID
     */
    function getSessionId()
    {
        return session_id();
    }

    /**
     * ѥ᡼̾եåID
     * 
     * @access public
     * @return string ѥ᡼̾եåID
     */
    function getSidQuery()
    {
        return session_name() . '=' . $this->getSessionId();
    }
}

?>
