<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmOperationUpd.php,v 1.5 2007/11/04 13:44:14 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ̥쥤䡼ǡ饹 - 
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmOperationUpd.php,v 1.5 2007/11/04 13:44:14 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_AdmOperationUpd extends SyL_AdmOperation
{
    /**
     * 饹Υץѥƥơ֥ȴϢ
     *
     * @access public
     */
    function loadConfig()
    {
        parent::loadConfig();

        // ǡޥǡ
        $data_sources = $this->form->getDataSources();
        foreach ($data_sources as $name => $data_source) {
            // ơ֥륪֥ȼ
            $table = null;
            if (version_compare(PHP_VERSION, '5.0.0', '>=')) {
                $table = unserialize(serialize($this->tables[$data_source['alias']]));
            } else {
                $table = $this->tables[$data_source['alias']];
            }
            $table->addColumn($data_source['name']);
            $table->addColumn($data_source['value']);

            // ¸options
            $element_config = $this->form->getConfig($name);
            if (!isset($element_config['options'])) {
                $element_config['options'] = array();
            }
            foreach ($this->dao->select($table) as $values) {
                $column_name  = current($values);
                $column_value = next($values);
                $element_config['options'][$column_value] = $column_name;
            }
            $this->form->addConfig($name, $element_config);
        }
    }

    /**
     * Хǡ¹
     *
     * @access public
     * @return bool Хǡ
     */
    function validate()
    {
        $result = parent::validate();
        if ($result) {
            // ᥤơ֥̾
            $name = $this->form->getMaintenanceTable();
            // Ϲܼ
            $input_columns = $this->form->getListColumns();

            foreach (array_keys($this->tables) as $alias) {
                if ($name == $alias) {
                    // ¸쥳ɼ
                    $record = $this->getRecord();
                    // 祭¸ߥå
                    $keys = array();
                    foreach ($this->tables[$alias]->getPrimary(false) as $column) {
                        if (in_array($column, $input_columns)) {
                            $keys[$column] = $this->form->getValue($column);
                            if (is_array($keys[$column]) && (count($keys[$column]) > 0)) {
                                $keys[$column] = current($keys[$column]);
                            }
                            if (($keys[$column] === null) || ($keys[$column] === '')) {
                                $keys = array();
                                break;
                            }
                        }
                    }
                    if (count($keys) > 0) {
                        // ¸ͤͤۤʤ뤫Ƚ
                        $diff = false;
                        foreach ($keys as $name1 => $value1) {
                            if (!isset($record[$name1]) || ($record[$name1] !== $value1)) {
                                $diff = true;
                                break;
                            }
                        }
                        if ($diff && $this->dao->hasPrimary($this->tables[$alias], $keys)) {
                            $result = false;
                            reset($keys);
                            $this->form->setErrorMessage(key($keys), implode(', ', array_map(array(&$this->form, 'getName'), array_keys($keys))) . 'ʼ祭ˤϴϿƤޤ');
                        }
                    }

                    // ե¸ߥå
                    $keys = array();
                    foreach ($this->tables[$alias]->getUniques(false) as $columns) {
                        foreach ($columns as $column) {
                            if (in_array($column, $input_columns)) {
                                $keys[$column] = $this->form->getValue($column);
                                if (is_array($keys[$column]) && (count($keys[$column]) > 0)) {
                                    $keys[$column] = current($keys[$column]);
                                }
                                if (($keys[$column] === null) || ($keys[$column] === '')) {
                                    $keys = array();
                                    break;
                                }
                            }
                        }
                        if (count($keys) > 0) {
                            // ¸ͤͤۤʤ뤫Ƚ
                            $diff = false;
                            foreach ($keys as $name1 => $value1) {
                                if (!isset($record[$name1]) || ($record[$name1] !== $value1)) {
                                    $diff = true;
                                    break;
                                }
                            }
                            if ($diff && $this->dao->hasUnique($this->tables[$alias], $keys)) {
                                $result = false;
                                reset($keys);
                                $this->form->setErrorMessage(key($keys), implode(', ', array_map(array(&$this->form, 'getName'), array_keys($keys))) . 'ʰեˤϴϿƤޤ');
                            }
                        }
                    }

                    // ¸ߥå
                    $keys = array();
                    foreach ($this->tables[$alias]->getForeigns(false) as $columns) {
                        foreach (array_keys($columns) as $column) {
                            if (in_array($column, $input_columns)) {
                                $keys[$column] = $this->form->getValue($column);
                                if (is_array($keys[$column]) && (count($keys[$column]) > 0)) {
                                    $keys[$column] = current($keys[$column]);
                                }
                                if (($keys[$column] === null) || ($keys[$column] === '')) {
                                    $keys = array();
                                    break;
                                }
                            }
                        }
                        if (count($keys) > 0) {
                            // ¸ͤͤۤʤ뤫Ƚ
                            $diff = false;
                            foreach ($keys as $name1 => $value1) {
                                if (!isset($record[$name1]) || ($record[$name1] !== $value1)) {
                                    $diff = true;
                                    break;
                                }
                            }
                            if ($diff && !$this->dao->hasForeign($this->tables[$alias], $keys, $ftabble)) {
                                $result = false;
                                reset($keys);
                                $this->form->setErrorMessage(key($keys), implode(', ', array_map(array(&$this->form, 'getName'), array_keys($keys))) . "δϢʳˤ{$ftabble}ơ֥¸ߤޤ");
                            }
                        }
                    }

                    break;
                }
            }
        }
        return $result;
    }

    /**
     * Ԥ
     *
     * @access public
     * @return bool true: OKfalse: 顼 
     */
    function update()
    {
        $table = null;
        foreach (array_keys($this->tables) as $alias) {
            if ($alias == $this->form->getMaintenanceTable()) {
                // ơ֥륪֥ȼ
                $table =& $this->tables[$alias];
                // ǡܽ
                $table->initDataColumns();
                // ǥեͼ
                $defaults = $this->form->getDefaults();
                // Ͽǡå
                foreach ($this->form->getValues($alias) as $name => $value) {
                    if (isset($defaults[$name])) {
                        if (($value !== '') && ($value !== null)) {
                            // ǥեͤܤϤƤͥ
                            unset($defaults[$name]);
                            $table->addColumn($name, $value);
                        }
                    } else {
                        $table->addColumn($name, $value);
                    }
                }
                // ǥեͤХå
                foreach ($defaults as $name => $value) {
                    if (is_array($value)) {
                        if (count($value) > 1) {
                            switch ($value[0]) {
                            case 'eval':
                                $table->addColumn($name, eval("return {$value[1]};"));
                                break;
                            case 'function':
                                array_shift($value);
                                $table->addColumn($name, $value);
                                break;
                            }
                        }
                    } else {
                        $table->addColumn($name, $value);
                    }
                }
                // 索֥Ⱥ
                $conditions = $this->dao->createCondition();
                // 祭糧å
                $this->setConditionKey($conditions, $alias);
                // 索֥ȥå
                $table->setConditions($conditions);
                break;
            }
        }

        if ($table) {
            return $this->dao->update($table);
        } else {
            return false;
        }
    }
}

?>
