<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_RouterXmlrpc.php,v 1.8 2007/09/29 09:10:39 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * XML᥽åɤե졼ͤ륯饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_RouterXmlrpc.php,v 1.8 2007/09/29 09:10:39 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_RouterXmlrpc extends SyL_Router
{
    /**
     * ζڤʸ
     *
     * @access private
     * @var string
     */
    var $action_delimiter = '.';

    /**
     * ܾ󥪥֥ȤΥץѥƥ
     *
     * @access protected
     * @param object ꥯȥ֥
     */
    function createActionInfo(&$data)
    {
         // SyL_DataXmlrpc饹ǥåȤ
        $pathinfo = explode($this->action_delimiter, $data->get(0));

        switch (count($pathinfo)) {
        case 0:
            $this->action_method = '';
            $this->action_file   = '/' . ucfirst($this->action_file_default);
            break;
        case 1:
            $this->action_method = array_pop($pathinfo);
            $this->action_file   = '/' . ucfirst($this->action_file_default);
            break;
        default:
            $this->action_method =  array_pop($pathinfo);
            $this->action_file   = '/' . implode('/', array_map('ucfirst', $pathinfo)) . $this->exe_ext;
            array_pop($pathinfo); // ե̾
            break;
        }

        // 饹ե
        $classname = implode('_', array_map('ucfirst', $pathinfo));
        if ($classname) {
            $this->action_class = $classname . '_' . basename($this->action_file, $this->exe_ext);
        } else {
            $this->action_class = basename($this->action_file, $this->exe_ext);
        }
    }

}

?>
