<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Config.php,v 1.17 2007/08/27 06:00:04 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * XML饹
 */
require_once SYL_INCLUDE_DIR . '/lib/Xml/SyL_XmlReader.php';
/**
 * å奯饹
 */
require_once SYL_INCLUDE_DIR . '/lib/SyL_Cache.php';

/** 
 * եɤ߹९饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Config.php,v 1.17 2007/08/27 06:00:04 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Config extends SyL_XmlReader
{
    /**
     * ٥̾
     * 
     * @access protected
     * @var string
     */
    var $event = '';
    /**
     * ǥեȼ¹Խ
     * 
     * @access protected
     * @param int
     */
    var $default_priority = 5;
    /**
     * åǥ쥯ȥ̾
     * 
     * @access protected
     * @param string
     */
    var $cache_dir_name = '';
    /**
     * ƥȥ֥
     * 
     * @access protected
     * @param object
     */
    var $context = null;
    /**
     * XMLե̾
     * 
     * @access private
     * @var array
     */
    var $file_names = array();
    /**
     * ե
     * 
     * @access private
     * @var array
     */
    var $config = array();

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param mixed XMLե̾
     */
    function SyL_Config($file_names)
    {
        $this->file_names = $file_names;
    }

    /**
     * ե륪֥Ȥ
     *
     * @static
     * @access public
     * @param string ե륪֥̾
     * @param array ե̾
     * @param object ȥ饪֥
     * @param string ٥̾
     * @return object ե륪֥
     */
    function &factory($config_name, $file_names, &$controller)
    {
        $class_name = 'SyL_Config' . ucfirst($config_name);
        include_once SYL_INCLUDE_DIR . "/framework/Config/{$class_name}.php";
        $obj = new $class_name($file_names);
        $obj->setContext($controller);
        return $obj;
    }

    /**
     * ƥȤ򥻥å
     *
     * @access protected
     * @param object ȥ饪֥
     */
    function setContext(&$controller)
    {
        $container =& $controller->getContainer();
        $this->context =& $container->getComponent('context');
    }

    /**
     * å奪֥Ȥ
     *
     * @access public
     * @param string åƬ
     * @param string ɲåʸ
     * @return object å奪֥
     */
    function &getCache($key)
    {
        // åѤ
        $mtime = 0;
        foreach ($this->file_names as $file_name) {
            $mtime_tmp = filemtime($file_name);
            if ($mtime < $mtime_tmp) {
                $mtime = $mtime_tmp;
            }
        }

        $cache =& SyL_Cache::factory(SYL_CACHE);
        $cache->setPrefix(basename($this->file_names[0]) . '.');
        $cache->setKey($key);
        $cache->setMinModifyTime($mtime);
        if (defined('SYL_CACHE_FILE_DIR') && SYL_CACHE_FILE_DIR) {
            $cache->setCacheDir(SYL_CACHE_FILE_DIR . basename($this->file_names[0]) . '/');
        }

        //$cache->useIncludeCache();

        $this->config = $cache->read();
        if ($this->config) {
            // åOK
            $cache = null;
            return $cache;
        } else {
            // åNG
            return $cache;
        }
    }

    /**
     * ʣXMLեβϤ
     *
     * @access public
     */
    function parseXml()
    {
        $config = array();
        foreach ($this->file_names as $file_name) {
            parent::setFile($file_name);
            parent::parseXml();
            if (is_array($this->config)) {
                $config += $this->config;
            }
            // 
            $this->config = array();
        }
        $this->config = $config;
    }

    /**
     * XMLǡƼϥɥ᥽å
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
    }

    /**
     * XMLͤ
     * 
     * @access public
     * @return array 
     */
    function getConfig()
    {
        return $this->config;
    }
}

?>
