/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id:$
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * Хǡ¹ԥ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id:$
 * @link      http://www.syl.jp/
 */
SyL_Validator = {
  /**
   * ̤ϥåԤ
   *
   * @access public
   * @param string 
   * @param object ץ
   * @return bool true: , false: 顼
   */
  isRequire: function(value, options)
  {
    if (options && options['trim']) {
      value = value.replace(/^\s+|\s+$/g, "");
    }
    return ((value != null) && (value != ""));
  },

  /**
   * ӥåԤ
   *
   * @access public
   * @param string 
   * @param object ץ
   * @return bool true: , false: 顼
   */
  isCompare: function(value, options)
  {
    var target  = options['target'];
    var compare = (options && options['compare']) ? options['compare'] : '==';
    switch (compare) {
    case '===':
    case '==':  return (value == target);
    case '!==':
    case '!=':  return (value != target);
    case '<=':  return (value <= target);
    case '>=':  return (value >= target);
    case '<':   return (value <  target);
    case '>':   return (value >  target);
    default:    return false;
    }
  },

  /**
   * ȾѿͥåԤ
   *
   * @access public
   * @param string 
   * @param object ץ
   * @return bool true: , false: 顼
   */
  isNumeric: function(value, options)
  {
    var regex;
    if (options && options['dot']) {
        regex = /^[\-\+]?[0-9]+(\.[0-9]+)?$/;
    } else {
        regex = /^[\-\+]?[0-9]+$/;
    }

    if (!value.match(regex)) {
      return false;
    }

    if (options) {
      if (!isNaN(options['min'])) {
        if (parseFloat(options['min'], 10) > parseFloat(value, 10)) {
          options['min_error'] = true;
          return false;
        }
      }
      if (!isNaN(options['max'])) {
        if (parseFloat(value, 10) > parseFloat(options['max'], 10)) {
          options['max_error'] = true;
          return false;
        }
      }
    }

    return true;
  },

  /**
   * ɽåԤ
   *
   * @access public
   * @param string 
   * @param object ץ
   * @return bool true: , false: 顼
   */
  isRegex: function(value, options)
  {
    var regex = options['format'];
    if (!(regex instanceof RegExp)) {
      if (typeof(regex) == 'string') {
        regex = new RegExp(regex);
      } else {
        return false;
      }
    }

    return value.match(regex);
  },

  /**
   * ХȿåԤ
   *
   * @access public
   * @param string 
   * @param object ץ
   * @return bool true: , false: 顼
   */
  isLength: function(value, options)
  {
    var bytes = SyL_Validator.getBytes(value);
    if (options['max']) {
      if (bytes > options['max']) {
        options['max_error'] = true;
        return false;
      }
    }
    if (options['min']) {
      if (options['min'] > bytes) {
        options['min_error'] = true;
        return false;
      }
    }

    return true;
  },

  /**
   * դå
   *
   * @access public
   * @param string 
   * @param object ץ
   * @return bool true: , false: 顼
   */
  isDate: function (value, options)
  {
    if (value.match(/^([0-9]{4})[\-\/]?([0-1][0-9])[\-\/]?([0-9]{2})\s?([0-1][0-9]|2[0-3]):?([0-5][0-9]):?([0-5][0-9])$/)) {
      yyyy = parseInt(RegExp.$1, 10);
      mm   = parseInt(RegExp.$2, 10);
      dd   = parseInt(RegExp.$3, 10);
      hh   = parseInt(RegExp.$4, 10);
      mi   = parseInt(RegExp.$5, 10);
      ss   = parseInt(RegExp.$6, 10);
    } else if (value.match(/^([0-9]{4})[\-\/]?([0-1][0-9])[\-\/]?([0-9]{2})$/)) {
      yyyy = parseInt(RegExp.$1, 10);
      mm   = parseInt(RegExp.$2, 10);
      dd   = parseInt(RegExp.$3, 10);
    } else {
      return false;
    }

    var date = new Date(yyyy, mm-1, dd); 
    if (!date || (yyyy != date.getFullYear()) || (mm != (date.getMonth() + 1))) {
      return false;
    }

    if (options) {
      var dt_date;
      if (options['date'] && options['date'].match(/^([0-9]{4})[\-\/]?([0-1][0-9])[\-\/]?([0-9]{2})$/)) {
        dt_date = new Date(parseInt(RegExp.$1, 10), parseInt(RegExp.$2, 10)-1, parseInt(RegExp.$3, 10)); 
        if (options['past']) {
          if (dt_date.getTime() < date.getTime()) {
            return false;
          }
        }
        if (options['future']) {
          if (dt_date.getTime() > date.getTime()) {
            return false;
          }
        }
      }

      if (options['min'] && options['min'].match(/^([0-9]{4})[\-\/]?([0-1][0-9])[\-\/]?([0-9]{2})$/)) {
        dt_date = new Date(parseInt(RegExp.$1, 10), parseInt(RegExp.$2, 10)-1, parseInt(RegExp.$3, 10)); 
        if (dt_date.getTime() > date.getTime()) {
          options['min_error'] = true;
          return false;
        }
      }

      if (options['max'] && options['max'].match(/^([0-9]{4})[\-\/]?([0-1][0-9])[\-\/]?([0-9]{2})$/)) {
        dt_date = new Date(parseInt(RegExp.$1, 10), parseInt(RegExp.$2, 10)-1, parseInt(RegExp.$3, 10)); 
        if (dt_date.getTime() < date.getTime()) {
          options['max_error'] = true;
          return false;
        }
      }
    }

    return true;
  },


  /**
   * Хȿ
   *
   * Ⱦѥʤ2Х
   * 
   * @access public
   * @param string Хȼо
   * @return int Хȿ
   */
  getBytes: function(value)
  {
    var bytes = 0;

    for (var i=0; i<value.length; i++) {
      // c < 0x7E
      //   ASCIIϰ
      bytes += (value.charCodeAt(i) <= 0x7E) ? 1 : 2;
    }
    return bytes;
  }
}

