<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmFlowLst.php,v 1.8 2007/11/19 14:18:03 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * եδ쥯饹
 */
require_once SYL_INCLUDE_DIR . '/framework/Adm/SyL_AdmFlow.php';

/**
 * ե饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmFlowLst.php,v 1.8 2007/11/19 14:18:03 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_AdmFlowLst extends SyL_AdmFlow
{
    /**
     * ڥ졼̾
     *
     * @access protected
     * @var string
     */
    var $opp_name = 'lst';

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_AdmFlowLst()
    {
        parent::SyL_AdmFlow();
    }

    /**
     * ᥽åɼ¹˼¹Ԥ᥽å
     *
     * @access public
     * @param object ǡ֥
     * @param object ƥȥ֥
     */
    function preExecute(&$data, &$context)
    {
        // AJAXʸѴ
        switch ($data->get('adm_ajax')) {
        case 'import':
        case 'json':
            $data->apply('mb_convert_encoding', SYL_ENCODE_INTERNAL, SYL_ENCODE_AJAX);
            break;
        }
        parent::preExecute($data, $context);
    }

    /**
     * ᥽åɼ¹Ը˼¹Ԥ᥽å
     * 
     * @access public
     * @param object ǡ֥
     * @param object ƥȥ֥
     */
    function postExecute(&$data, &$context)
    {
        parent::postExecute($data, $context);

        switch ($data->get('adm_ajax')) {
        case 'import':
            $data->apply('mb_convert_encoding', SYL_ENCODE_AJAX, SYL_ENCODE_INTERNAL);
            $context->setViewType('js.ajax');
            break;
        case 'json':
            $data->apply('mb_convert_encoding', SYL_ENCODE_AJAX, SYL_ENCODE_INTERNAL);
            $context->setViewType('json');
            break;
        }
    }

    /**
     * ɽե
     *
     * @access public
     * @param object ǡ֥
     * @param object ƥȴ֥
     */
    function execute(&$data, &$context)
    {
        // JSݡȻϥ󥹥å
        if ($data->get('adm_ajax') == 'import') {
            return;
        }

        // ѥ᡼
        $sort = $data->get('sort');
        $page = $data->get('page');
        $index = $data->get('adm_list_index'); // AjaxξΤ߻

        // ե
        $form =& $this->getForm();
        // ǡ֥ȥå
        $form->registerInput($data);
        // ե๽
        $form->buildSearch();

        // DB³
        $conn =& $this->getDB();

        // ADM֥Ⱥ
        $adm =& SyL_Adm::factory($form, $conn);
        // ơ֥
        $adm->loadConfig();
        // å
        if (!$adm->isLst()) {
            // Բ
            echo '<h2>403 Forbidden</h2>';
            exit;
        }

        // ɽǡ
        $results = $adm->getList($sort, $page, '');
        // Ȥθѥ᡼
        $search_parameter = implode('&', $adm->getSearchParameters());
        // إåɽܼ
        $headers = $adm->getSelectHeaders();
        // ȤΥȹܼ
        $current_sort = $adm->getSortColumns();

        // ڡ֥ȼ
        $pager =& $adm->getPager();
        // 󥯥ڡϰϼ
        $links        = $adm->getPageLinks($pager, $form->getStructConfig('link_range'));
        $current_page = $pager->getCurrentPage();
        $max_page     = $pager->getTotalPage();

        // ǥեȸɽ
        $search_view = $adm->isDefaultSearchView();

        // DB³λ
        $this->closeDB($conn);

        // ץ饤ޥꥭ
        $primaries    = $adm->getPrimary(false);
        $primary_name = '';
        if (count($primaries) > 0) {
            $primary_name = $primaries[0];
        }
        // ץ饤ޥ꡼󥯥ѥ᡼
        $primary_link_parameters = $adm->getPrimaryLinkParameters($results);

        // 󥯼
        if ($search_parameter != '') {
            $search_parameter = '&' . $search_parameter;
            $search_view  = true;
        }

        // եǥǡϢ
        $data->set('form', $form->getResultArray());
        $data->set('search_view', $search_view);

        // ɽǡϢ
        $data->set('headers', $headers);
        $data->set('results', $results);

        // 祭ѥ᡼
        $data->set('key_name',     $form->getStructConfig('key_name'));
        $data->set('primary_name', $primary_name);
        $data->set('primary_link_parameters', $primary_link_parameters);

        // ڡ󥯴Ϣѥ᡼
        $data->set('links',        $links);
        $data->set('max_page',     $max_page);
        $data->set('current_page', $current_page);
        $data->set('current_sort', $current_sort);
        $data->set('search_parameter', $search_parameter);

       // ǧɽϢ
        $data->set('view_alert', $form->getStructConfig('view_alert'));

        // URL
        $data->set('url_lst', $this->getUrl('lst'));
        $data->set('url_new', $this->getUrl('new'));
        $data->set('url_upd', $this->getUrl('upd'));
        $data->set('url_vew', $this->getUrl('vew'));
        $data->set('url_del', $this->getUrl('del'));
        $data->set('url_dir', dirname($this->getScriptName()));

        // ʸϢ
        $data->set('title', $form->getStructConfig('title'));

        // Ͽǽե饰
        $data->set('enable_new', $adm->isNew());
        // Խǽե饰
        $data->set('enable_upd', $adm->isUpd());
        // ǽե饰
        $data->set('enable_del', $adm->isDel());
        // Ȳǽե饰
        $data->set('enable_vew', $adm->isVew());

        // AjaxΤߡϢ󥯥ǥå
        $data->set('index', $index);
    }
}

?>
