<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Action.php,v 1.6 2007/11/19 14:18:03 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 󥯥饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Action.php,v 1.6 2007/11/19 14:18:03 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Action
{
    /**
     * ᥽åɼ¹˼¹Ԥ᥽å
     *
     * @access public
     * @param object ǡ֥
     * @param object ƥȥ֥
     */
    function preExecute(&$data, &$context)
    {
    }

    /**
     * ᥽åɼ¹Ը˼¹Ԥ᥽å
     * 
     * @access public
     * @param object ǡ֥
     * @param object ƥȥ֥
     */
    function postExecute(&$data, &$context)
    {
    }


    // -----------------------------------------------------
    // DBϢ̥᥽å
    // -----------------------------------------------------

    /**
     * DB֥Ȥ
     *
     * @access protected
     * @param string DSNʸ
     * @return object DB֥
     */
    function &getDB($dsn='')
    {
        static $dsns = array();
        if (!isset($dsns[$dsn])) {
            // DB饹󥯥롼
            include_once SYL_INCLUDE_DIR . '/lib/SyL_DB.php';
            // DB֥ȼ
            $dsns[$dsn] =& SyL_DB::getConnection($dsn);
            $dsns[$dsn]->setCallbackSqlLog(array(__CLASS__, 'addLogDBSql'));
            $dsns[$dsn]->setCallbackErrorLog(array(__CLASS__, 'addLogDBError'));
            //register_shutdown_function(array(&$dsns[$dsn], 'closeConnection'));
            SyL_Loggers::info("getDB for Action");
        }
        return $dsns[$dsn];
    }

    /**
     * DB֥Ȥ³
     *
     * @access protected
     * @param object DB֥
     */
    function closeDB(&$conn)
    {
        if (is_object($conn)) {
            $conn->closeConnection();
            $conn = null;
            SyL_Loggers::info("DB connection end");
        }
    }

    /**
     * SQL˵Ͽ
     *
     * @static
     * @access private
     * @param string å
     */
    function addLogDBSql($message)
    {
        SyL_Loggers::debug($message);
    }

    /**
     * DB顼˵Ͽ
     *
     * @static
     * @access private
     * @param string å
     */
    function addLogDBError($message)
    {
        SyL_Loggers::error($message);
    }


    // -----------------------------------------------------
    // ǧڴϢ̥᥽å
    // -----------------------------------------------------

    /**
     * 桼֥Ȥ
     *
     * @access protected
     * @return object 桼֥
     */
    function &getUser()
    {
        // AUTH饹󥯥롼
        include_once SYL_INCLUDE_DIR . '/framework/SyL_Auth.php';
        $auth =& SyL_Auth::singleton();
        return $auth->getUser();
    }

    /**
     * 桼֥Ȥ
     *
     * @access protected
     * @return object 桼֥
     */
    function setUser(&$user)
    {
        // AUTH饹󥯥롼
        include_once SYL_INCLUDE_DIR . '/framework/SyL_Auth.php';
        $auth =& SyL_Auth::singleton();
        $auth->setUser($user);
    }

    /**
     * Ȥ
     *
     * @access protected
     * @return object 桼֥
     */
    function doLogout()
    {
        // AUTH饹󥯥롼
        include_once SYL_INCLUDE_DIR . '/framework/SyL_Auth.php';
        $auth =& SyL_Auth::singleton();
        $auth->doLogout();
    }


    // -----------------------------------------------------
    // եϢ̥᥽å
    // -----------------------------------------------------

    /**
     * ե४֥Ȥ
     *
     * @access protected
     * @param object ǡ֥
     * @param string ե९饹̾
     * @param bool ɽե饰
     * @return object ե४֥
     */
    function &getActionForm(&$data, $form_class, $first=false)
    {
        $form = null;
        if ($form == null) {
            // ե।󥯥롼
            include_once SYL_INCLUDE_DIR . '/framework/SyL_ActionForm.php';
            // ե
            $form =& SyL_ActionForm::factory($form_class);
            // ǡ֥ȥå
            $form->registerInput($data);
            // ե๽
            $form->build($first);
        }
        return $form;
    }
}

?>
