<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FileWriter.php,v 1.3 2007/05/27 16:24:29 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * եϥ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FileWriter.php,v 1.3 2007/05/27 16:24:29 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_FileWriter extends SyL_File
{
    /**
     * ե륪ץ⡼
     * 
     * @access protected
     * @var string
     */
    var $mode = 'wb';

    /**
     * ե򳫤
     *
     * @access public
     * @param string ץ⡼
     */
    function open()
    {
        parent::open();
        $this->setFileBuffer(0);
    }

    /**
     * ե뤫ɤ߹
     *
     * @access public
     * @return string ϥǡ or bool(false) ɤ߹߽λ
     */
    function read()
    {
        trigger_error("[SyL error] Unable to read method in " . get_class($this) . " class", E_USER_ERROR);
    }

    /**
     * ե˽Ϥ
     *
     * @access public
     * @param string å or CSV array
     */
    function write($message)
    {
        if ($this->csv) {
            if (!is_array($message)) {
                $message = array($message);
            }
            $message = $this->csv_enclosure . implode($this->csv_enclosure . $this->csv_delimiter . $this->csv_enclosure, $message) . $this->csv_enclosure . $this->eol;
        }

        flock ($this->fp, LOCK_EX);
        fseek($this->fp, 0, SEEK_END);
        fwrite($this->fp, $this->convertEncode($message));
        flock ($this->fp, LOCK_UN);
    }

    /**
     * ե˽Ϥ˲Ԥղä
     *
     * @access public
     * @param string å or CSV array
     */
    function writeln($message)
    {
        if (is_string($message)) {
            $message .= $this->eol;
        }
        $this->write($message);
    }

    /**
     * ե˽ϤϢν¹Ԥ
     *
     * @access public
     * @param string ϥå
     */
    function process($message)
    {
        $this->open();
        $this->write($message);
        $this->close();
    }

    /**
     * ϥ󥳡ǥ󥰤Ѵ
     *
     * @access protected
     * @param string 󥳡ǥѴΥեΥǡ
     * @return string 󥳡ǥѴΥեΥǡ
     */
    function convertEncode($data)
    {
        if ($this->encode_file) {
            return ($this->encode_script)
                 ? mb_convert_encoding($data, $this->encode_file, $this->encode_script)
                 : mb_convert_encoding($data, $this->encode_file);
        } else {
            return $data;
        }
    }
}

?>
