<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Response.php,v 1.16 2007/11/19 14:18:03 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ̱饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Response.php,v 1.16 2007/11/19 14:18:03 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Response
{
    /**
     * ɲHTTP쥹ݥ󥹥إå
     * 
     * @access public
     * @var array
     */
    var $headers = array();

    /**
     * HTTP쥹ݥ󥹥֥Ȥ
     * 
     * @access public
     * @return object HTTP쥹ݥ󥹥֥
     */
    function &singleton()
    {
        static $singleton;
        if (!is_object($singleton)) {
            $class_name = __CLASS__;
            $singleton = new $class_name();
        }
        return $singleton;
    }

    /**
     * 쥯Ȥ
     *
     * RFCˤʤ٤ह褦ˡʼǤС˼ưURLåȤ
     * 
     * @static
     * @access public
     * @param string 쥯URL
     */
    function redirect($url)
    {
        if (!preg_match('/^[a-z]+:\/\/(.+)/i', $url)) {
            $protocol = 'http';
            if (isset($_SERVER['HTTPS'])) {
                $protocol = 'https';
            } else if (isset($_SERVER['SERVER_PORT']) && ($_SERVER['SERVER_PORT'] == '443')) {
                $protocol = 'https';
            }

            $server = '';
            if (isset($_SERVER['HTTP_HOST'])) {
                $server = $_SERVER['HTTP_HOST'];
            } else if (isset($_SERVER['SERVER_NAME'])) {
                $server = $_SERVER['SERVER_NAME'];
                if (isset($_SERVER['SERVER_PORT'])) {
                    $server .= ':' . $_SERVER['SERVER_PORT'];
                }
            }

            if ($protocol && $server) {
                if (substr($url, 0, 1) == '/') {
                    $url = "{$protocol}://{$server}{$url}";
                } else {
                    $path = '';
                    if (strpos(SYL_ROUTER_RULE, 'pathinfo') !== false) {
                        if (isset($_SERVER['PHP_SELF'])) {
                            $path = $_SERVER['PHP_SELF'];
                        }
                    } else {
                        if (isset($_SERVER["SCRIPT_NAME"])) {
                            $path = $_SERVER["SCRIPT_NAME"];
                        }
                    }
                    if (($path !== '') && (substr($path, -1) != '/')) {
                        $path = dirname($path) . '/';
                    }
                    if ($path) {
                        $path .= $url;
                        while (preg_match('/^(.+\/)([^\/]+\/\.\.\/)(.+)$/', $path, $matches)) {
                            $path = $matches[1] . $matches[3];
                        }
                        $path = str_replace('./', '', $path);
                        $url = "{$protocol}://{$server}{$path}";
                    }
                }
            }
        }

        if (SYL_ENV_TYPE == 'js') {
            // JSǻѤ硢301 ϥ֥饦٥ǥ쥯Ȥ뤿306
            SyL_Response::setStatusHeader('306');
            SyL_Loggers::info("Redirect(306) -> {$url}");
        } else {
            SyL_Response::setStatusHeader('301');
            SyL_Loggers::info("Redirect(301) -> {$url}");
        }
        SyL_Response::setHeader('Location', $url);
        $obj =& SyL_Response::singleton();
        $obj->sendHeader();

        exit;
    }

    /**
     * 404 Not Found ̤˥եɤ
     *
     * @access public
     */
    function forward404()
    {
        // Хåե󥰥ꥢ
        if (!headers_sent() && (ob_get_level() > 0)) {
            ob_clean();
        }

        SyL_Response::setStatusHeader('404');
        SyL_Loggers::notice("404 Not Found");
        if (SYL_ENV_TYPE == 'web') {
            include_once SYL_ERROR_FORWARD_FILE_404;
        } else {
            echo "File Not Found";
        }
        exit;
    }

    /**
     * HTTP쥹ݥ󥹥إå򥻥åȤ
     * 
     * @static
     * @access public
     * @param string إå̾
     * @param string إå
     */
    function setHeader($name, $value='')
    {
        $response =& SyL_Response::singleton();
        $response->headers[$name] = $value;
    }

    /**
     * HTTP쥹ݥ󥹥ơإå򥻥åȤ
     * 
     * @static
     * @access public
     * @param string ơ
     * @param string إå
     */
    function setStatusHeader($status_code)
    {
        $status_header = SyL_Response::getStatusHeader($status_code);
        SyL_Response::setHeader($status_header);
    }

    /**
     * HTTP쥹ݥ󥹥إå
     * 
     * @static
     * @access public
     * @param string إå̾
     */
    function getHeader($name)
    {
        $name = strtolower($name);

        $response =& SyL_Response::singleton();
        foreach ($response->getCustomHeaders() as $tmp_name => $tmp_value) {
            if ($name == strtolower($tmp_name)) {
                return $tmp_value;
            }
        }

        if (function_exists('headers_list')) {
            // 5.0
            foreach (headers_list() as $header) {
                $header_values = explode(':', $header, 2);
                if ($name == strtolower(trim($header_values[0]))) {
                    return trim($header_values[1]);
                }
            }
        } else if (function_exists('apache_response_headers')) {
            foreach (apache_response_headers() as $tmp_name => $tmp_value) {
                if ($name == strtolower($tmp_name)) {
                    return $tmp_value;
                }
            }
        }

        return false;
    }

    /**
     * HTTP쥹ݥ󥹥إå
     * 
     * @access public
     * @return array إå
     */
    function getCustomHeaders()
    {
        return $this->headers;
    }

    /**
     * HTTP쥹ݥ󥹥إå
     * 
     * @access public
     */
    function sendHeader()
    {
        foreach ($this->getCustomHeaders() as $name => $value) {
            if ($value) {
                header("$name: $value");
            } else {
                header("$name");
            }
        }
    }

    /**
     * gzip̤ѲǽʤѤ
     * 
     * @access public
     * @param string ϥǡ
     * @return bool true: gzip̡false: ̾
     */
    function convertGzip(&$data)
    {
        $convert = false;
        if (extension_loaded('zlib')) {
            if (isset($_SERVER['HTTP_ACCEPT_ENCODING']) && preg_match('/((x\-)?gzip)/', $_SERVER['HTTP_ACCEPT_ENCODING'], $matches)) {
                SyL_Response::setHeader('Content-Encoding', $matches[1]);
                SyL_Response::setHeader('Vary', 'Accept-Encoding');

                $size = strlen($data);
                $crc  = crc32($data);
                $data = gzcompress($data, SYL_RESPONSE_GZIP);
                $data = substr($data, 0, strlen($data) - 4);
                $data = "\x1f\x8b\x08\x00\x00\x00\x00\x00" . $data . pack('V', $crc) . pack('V', $size);
                $convert = true;
            }
        }
        return $convert;
    }

    /**
     * 󥰤줿HTML
     * 
     * @access public
     * @param object ӥ塼֥
     */
    function display(&$view)
    {
        $data           = '';
        $content_type   = false;
        $content_length = false;
        $gzip_compress  = false;

        if (is_object($view)) {
            if (is_a($view, 'SyL_ViewNull')) {
                return;
            }
            $data           =& $view->getRender();
            $content_type   =  $view->getContentType();
            $content_length =  $view->isContentLength();
            $gzip_compress  =  $view->isGzipCompress();
        } else {
            $data =& $view;
        }

        // Last-Modified & EtagåλȽ
        if (SYL_CACHE && SYL_RESPONSE_LAST_MODIFIED_CACHE && (
             (isset($_SESSION)  && (SYL_SESSION_CACHE  != 'nocache')) ||
             (!isset($_SESSION) && (SYL_RESPONSE_CACHE != 'nocache'))
           )) {
            // ǿMD5
            $data_new_md5 = md5($data);

            // å奯饹
            include_once SYL_INCLUDE_DIR . '/lib/SyL_Cache.php';
            // å奪֥ȼ
            $cache =& SyL_Cache::factory(SYL_CACHE);
            $cache->setPrefix('response.');
            $cache->setKey($_SERVER['REQUEST_URI']);

            // HTTP_IF_NONE_MATCH
            $if_none_match = isset($_SERVER['HTTP_IF_NONE_MATCH']) ? $_SERVER['HTTP_IF_NONE_MATCH'] : '';
            // Last-Modified
            $if_modified_since = isset($_SERVER['HTTP_IF_MODIFIED_SINCE']) ? $_SERVER['HTTP_IF_MODIFIED_SINCE'] : '';

            if ($if_none_match) {
                $if_none_match = trim(strtr($if_none_match, array('\\"' => '', '"' => '')));
                // ǿMD5ȡʥ֥饦˥åMD5
                if ($data_new_md5 == $if_none_match) {
                    // ѹʤ
                    SyL_Loggers::info("Not Modified(304) Etag: {$data_new_md5}");
                    SyL_Response::setStatusHeader('304');
                    $this->sendHeader();
                    exit;
                } else {
                    // åǿMD5ؤ
                    $cache->write($data_new_md5);
                }
            } else if ($if_modified_since) {
                $cache->setMaxModifyTime(strtotime($if_modified_since));
                // ǿMD5ȥåMD5
                if ($data_new_md5 == $cache->read()) {
                    // ѹʤ
                    SyL_Loggers::info("Not Modified(304) Etag: {$data_new_md5}");
                    SyL_Response::setStatusHeader('304');
                    $this->sendHeader();
                    exit;
                } else {
                    // åǿMD5ؤ
                    $cache->write($data_new_md5);
                }
            } else {
                if ($cache->read() === false) {
                    // åʤ => å
                    $cache->write($data_new_md5);
                }
            }
            // Last-Modifiedå
            SyL_Response::setHeader('Last-Modified', gmdate('D, d M Y H:i:s T', $cache->getModifyTime()));
            // Etagå
            SyL_Response::setHeader('Etag', '"' . $data_new_md5 . '"');
        }

        // ƥĥפ򥻥å
        if ($content_type) {
            SyL_Response::setHeader('Content-Type', $content_type);
        }
        // gzip̤ѲǽʤѤ
        if ($gzip_compress) {
            $this->convertGzip($data);
        }
        // ƥ̤򥻥å
        if ($content_length) {
            SyL_Response::setHeader('Content-Length', strlen($data));
        }

        // åإå򥻥å
        if (!isset($_SESSION)) {
            switch (SYL_RESPONSE_CACHE) {
            case 'nocache':
                SyL_Response::setHeader('Cache-Control', 'no-store, no-cache, must-revalidate, post-check=0, pre-check=0');
                SyL_Response::setHeader('Expires', 'Thu, 19 Nov 1981 08:52:00 GMT');
                SyL_Response::setHeader('Pragma', 'no-cache');
                break;
            case 'private':
                SyL_Response::setHeader('Expires', 'Thu, 19 Nov 1981 08:52:00 GMT');
            case 'private_no_expire':
                SyL_Response::setHeader('Cache-Control', 'private, max-age=10800, pre-check=10800');
                break;
            case 'public':
                SyL_Response::setHeader('Cache-Control', 'public, max-age=10800');
                break;
            }
        }

        // إå
        $this->sendHeader();
        // ɽǡ
        echo $data;

        // Хåե󥰽
        $neste = ob_get_level();
        for ($i=0; $i<$neste; $i++) {
            ob_end_flush();
        }

        // 
        $data = null;
    }

    /**
     * ơɤ饹ơإå
     * 
     * @static
     * @access public
     * @param string ơ
     * @param string HTTPС
     * @return string ơإå
     */
    function getStatusHeader($status_code, $http_version='1.0')
    {
        $message = '';
        switch ($status_code) {
        case '100': $message = 'Continue'; break;
        case '101': $message = 'Switching Protocols'; break;
        case '200': $message = 'OK'; break;
        case '201': $message = 'Created'; break;
        case '202': $message = 'Accepted'; break;
        case '203': $message = 'Non-Authoritative Information'; break;
        case '204': $message = 'No Content'; break;
        case '205': $message = 'Reset Content'; break;
        case '206': $message = 'Partial Content'; break;
        case '300': $message = 'Multiple Choices'; break;
        case '301': $message = 'Moved Permanently'; break;
        case '302': $message = 'Found'; break;
        case '303': $message = 'See Other'; break;
        case '304': $message = 'Not Modified'; break;
        case '305': $message = 'Use Proxy'; break;
        case '306': $message = '(Unused)'; break;
        case '307': $message = 'Temporary Redirect'; break;
        case '400': $message = 'Bad Request'; break;
        case '401': $message = 'Unauthorized'; break;
        case '402': $message = 'Payment Required'; break;
        case '403': $message = 'Forbidden'; break;
        case '404': $message = 'Not Found'; break;
        case '405': $message = 'Method Not Allowed'; break;
        case '406': $message = 'Not Acceptable'; break;
        case '407': $message = 'Proxy Authentication Required'; break;
        case '408': $message = 'Request Timeout'; break;
        case '409': $message = 'Conflict'; break;
        case '410': $message = 'Gone'; break;
        case '411': $message = 'Length Required'; break;
        case '412': $message = 'Precondition Failed'; break;
        case '413': $message = 'Request Entity Too Large'; break;
        case '414': $message = 'Request-URI Too Long'; break;
        case '415': $message = 'Unsupported Media Type'; break;
        case '416': $message = 'Requested Range Not Satisfiable'; break;
        case '417': $message = 'Expectation Failed'; break;
        case '500': $message = 'Internal Server Error'; break;
        case '501': $message = 'Not Implemented'; break;
        case '502': $message = 'Bad Gateway'; break;
        case '503': $message = 'Service Unavailable'; break;
        case '504': $message = 'Gateway Timeout'; break;
        case '505': $message = 'HTTP Version Not Supported'; break;
        default   : return false;
        }

        return "HTTP/{$http_version} {$status_code} {$message}";
    }
}

?>
