<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Mail.php,v 1.14 2007/12/29 09:15:29 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ᡼ƤΥ󥳡ǥ
 */
if (!defined('SYL_ENCODE_MAIL')) {
    define('SYL_ENCODE_MAIL', 'ISO-2022-JP');
}
/**
 * 󥳡ǥ
 */
if (!defined('SYL_ENCODE_INTERNAL')) {
    define('SYL_ENCODE_INTERNAL', 'EUC-JP');
}

/**
 * ᡼饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Mail.php,v 1.14 2007/12/29 09:15:29 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Mail
{
    /**
     * ᡼ץѥƥ
     * 
     * @access protected
     * @var array
     */
    var $mail_property = array();
    /**
     * ᡼إå
     * 
     * @access protected
     * @var array
     */
    var $headers = array();
    /**
     * ʸ
     *
     * [body]              - ʸ
     * [name]              - źեե̾
     * [file]              - źեե
     * [type]              - Content-Type
     * [transfer_encoding] - Content-Transfer-Encoding
     * 
     * @access protected
     * @var array
     */
    var $attachments = array();
    /**
     * X-Mailerإå
     * 
     * @access protected
     * @var string
     */
    var $x_mailer = 'SyL Mail';
    /**
     * 󥳡
     *
     * Base64Τб
     * 
     * B: base64
     * Q: Quoted-Printable
     * 
     * @access protected
     * @var string
     */
    var $transfer_encoding = 'B';
    /**
     * 
     * 
     * @access protected
     * @var string
     */
    var $eol = "\r\n";
    /**
     * ᡼ƤΥ󥳡
     * 
     * @access protected
     * @var string
     */
    var $mail_encode = SYL_ENCODE_MAIL;
    /**
     * ѥ᡼Υ󥳡
     * 
     * @access protected
     * @var string
     */
    var $internal_encode = SYL_ENCODE_INTERNAL;
    /**
     * 顼å
     * 
     * @access protected
     * @var string
     */
    var $error_message = '';

    /**
     * 󥹥ȥ饯
     * 
     * @access public
     */
    function SyL_Mail()
    {
        // ʲǥեȥإå
        $this->headers['MIME-Version'] = '1.0';
        if ($this->x_mailer) {
            $this->headers['X-Mailer'] = $this->x_mailer;
        }
        $this->init();
    }

    /**
     * SyL_Mail饹Υ󥹥󥹼
     *
     * @access public
     * @param string ᡼
     */
    function &factory($type='Default')
    {
        $types = explode(':', $type, 2);
        if (!isset($types[1])) {
            $types[1] = null;
        }
        $class_name = 'SyL_Mail' . ucfirst($types[0]);
        include_once dirname(__FILE__) . '/Mail/' . $class_name . '.php';
        $mail = new $class_name($types[1]);
        return $mail;
    }

    /**
     * ᡼륨󥳡ɤ򥻥åȤ
     *
     * @access public
     * @param string ᡼륨󥳡
     */
    function setMailEncode($mail_encode)
    {
        $this->mail_encode = $mail_encode;
    }

    /**
     * ѥ᡼󥳡ɤ򥻥åȤ
     *
     * @access public
     * @param string ѥ᡼󥳡
     */
    function setInternalEncode($internal_encode)
    {
        $this->internal_encode = $internal_encode;
    }

    /**
     * ɥ쥹򥻥å
     *
     * @access public
     * @param string ɥ쥹
     * @param string ̾
     */
    function setFrom($from, $name='')
    {
        $this->mail_property['MAIL_FROM'] = $from;
        $this->mail_property['Reply-To']  = $from;
        $this->headers['From'] = $this->convertEncodingAddress($from, $name);
    }

    /**
     * 襢ɥ쥹򥻥å
     * 
     * @access public
     * @param mixed 襢ɥ쥹
     * @param string ̾
     */
    function addTo($to, $name='')
    {
        if (is_array($to)) {
            foreach($to as $tmp) {
                $this->addTo($tmp, $name);
            }
        } else {
            $this->mail_property['RCPT_TO'][] = $to;
            $this->headers['To'][] = $this->convertEncodingAddress($to, $name);
        }
    }

    /**
     * 襢ɥ쥹(CC)򥻥å
     * 
     * @access public
     * @param mixed 襢ɥ쥹(CC)
     * @param string ̾(CC)
     */
    function addCc($cc, $name='')
    {
        if (is_array($cc)) {
            foreach($cc as $tmp) {
                $this->addCc($tmp, $name);
            }
        } else {
            $this->mail_property['RCPT_TO'][] = $cc;
            $this->headers['Cc'][] = $this->convertEncodingAddress($cc, $name);
        }
    }

    /**
     * 襢ɥ쥹(BCC)򥻥å
     * 
     * @access public
     * @param mixed 襢ɥ쥹(BCC)
     * @param string ̾(BCC)
     */
    function addBcc($bcc, $name='')
    {
        if (is_array($bcc)) {
            foreach($bcc as $tmp) {
                $this->addBcc($tmp, $name);
            }
        } else {
            $this->mail_property['RCPT_TO'][] = $bcc;
            $this->headers['Bcc'][] = $this->convertEncodingAddress($bcc, $name);
        }
    }

    /**
     * ̾򥻥å
     * 
     * @access public
     * @param string ̾
     */
    function setSubject($subject)
    {
        $this->headers['Subject'] = $this->convertEncoding($subject, true);
    }

    /**
     * ʸ򥻥å
     * 
     * @access public
     * @param string ʸ
     */
    function setBody($body)
    {
        $this->attachments[] = array(
          'body'              => $this->convertEncoding($body),
          'type'              => 'text/plain; charset="' . $this->mail_encode . '"',
          'transfer_encoding' => '7bit'
        );
    }

    /**
     * ѥ᡼᡼ʸ˥󥳡ɤ
     *
     * @access private
     * @param string 󥳡оʸ
     * @param bool MIME󥳡ɥե饰
     * @return 󥳡ɸʸ
     */
    function convertEncoding($parameter, $mime_encode=false)
    {
        $parameter = mb_convert_encoding(mb_convert_kana($parameter, 'KV', $this->internal_encode), $this->mail_encode, $this->internal_encode);
        return ($mime_encode) ? mb_encode_mimeheader($parameter, $this->mail_encode, $this->transfer_encoding) : $parameter;
    }

    /**
     * ᡼륢ɥ쥹᡼ʸ˥󥳡ǥ
     * 
     * @access private
     * @param string ᡼륢ɥ쥹
     * @param string ᡼륢ɥ쥹̾
     * @return string 󥳡ǥ󥰤Υ᡼륢ɥ쥹
     */
    function convertEncodingAddress($address, $name='')
    {
        if ($name) {
            return '"' . $this->convertEncoding($name, true) . '" <' . $address . '>';
        } else {
            return $address;
        }
    }

    /**
     * ¾Υ᡼إå򥻥å
     * 
     * @access public
     * @param string إåΥ
     * @param string إå
     */
    function setHeader($key, $value)
    {
        $this->headers[$key] = $value;
    }

    /**
     * ¾Υ᡼إå򥻥åȡʣб
     * 
     * @access public
     * @param array إåΥͤΥڥ
     */
    function setHeaders($headers)
    {
        $this->headers += $headers;
    }

    /**
     * źեե򥻥å
     * 
     * @access public
     * @param string եѥʥե̾ޤǴޤ
     */
    function addFile($path, $contents_type='application/octet-stream')
    {
        // ե̾
        $name = basename($path);
        // źեե
        $contents = file_get_contents($path);
        switch ($this->transfer_encoding) {
        case 'B':
            $contents = chunk_split(base64_encode($contents));
            $transfer_encoding = 'Base64';
            break;
        default:
            trigger_error("[SyL error] Content-Transfer-Encoding not supported ({$this->transfer_encoding})", E_USER_ERROR);
            break;
        }
        
        // źեե󥻥å
        $this->attachments[] = array(
          'name'              => $this->convertEncoding($name, true),
          'file'              => $contents,
          'type'              => $contents_type,
          'transfer_encoding' => $transfer_encoding
        );
    }

    /**
     * ᡼
     *
     * @access public
     * @param array ᡼°
     */
    function init($attributes=array())
    {
        $attributes = array_change_key_case($attributes, CASE_LOWER);

        // ǡ
        $this->mail_property['MAIL_FROM'] = '';
        $this->mail_property['RCPT_TO']   = array();

        // 긵
        $this->headers['From'] = '';
        if (isset($attributes['from'])) {
            $this->setFrom($attributes['from']);
        }
        // 
        $this->headers['To'] = array();
        if (isset($attributes['to'])) {
            $this->setTo($attributes['to']);
        }
        // Cc
        $this->headers['Cc'] = array();
        if (isset($attributes['cc'])) {
            $this->setCc($attributes['cc']);
        }
        // Bcc
        $this->headers['Bcc'] = array();
        if (isset($attributes['bcc'])) {
            $this->setBcc($attributes['bcc']);
        }
        // ̾
        $this->headers['Subject'] = '';
        if (isset($attributes['subject'])) {
            $this->setSubject($attributes['subject']);
        }
        // ̾
        $this->body = '';
        if (isset($attributes['body'])) {
            $this->setBody($attributes['body']);
        }
    }

    /**
     * ᡼إåޤʸ
     *
     * @access public
     * @return string ᡼إåޤʸ
     */
    function createSendMessage()
    {
        // ᡼إå
        $data  = '';
        // Х
        $boundary = '--' . md5(uniqid(rand()));
        // Ƽإå򥻥å
        foreach ($this->headers as $name => $value) {
            if (is_array($value)) {
                $value = implode(', ', $value);
            }
            $data .= "{$name}: {$value}" . $this->eol;
        }
        switch (count($this->attachments)) {
        case 0:
            break;
        case 1:
            $data .= $this->getAttachmentData($this->attachments[0]);
            break;
        default:
            $data .= "Content-Type: multipart/mixed; boundary=\"$boundary\"" . $this->eol;
            $data .= $this->eol;
            for ($i=0; $i<count($this->attachments); $i++) {
                $data .= '--' . $boundary . $this->eol;
                $data .= $this->getAttachmentData($this->attachments[$i]);
            }
            $data .= '--' . $boundary . "--" . $this->eol;
        }
        return $data;
    }

    /**
     * ʸźǡ
     *
     * @access public
     * @param array ǡ
     * @return string ʸźǡ
     */
    function getAttachmentData(&$attachment)
    {
        $data  = '';
        $data .= "Content-Type: {$attachment['type']}" . $this->eol;
        $data .= "Content-Transfer-Encoding: {$attachment['transfer_encoding']}" . $this->eol;
        if (isset($attachment['body'])) {
            // ƥ
            $data .= $this->eol;
            $data .= $attachment['body'] . $this->eol;
        } else {
            // ź
            $data .= "Content-Disposition: attachment; filename=\"{$attachment['name']}\"" . $this->eol;
            $data .= $this->eol;
            $data .= $attachment['file'] . $this->eol;
        }
        return $data;
    }

    /**
     * ᡼¹
     *
     * @access public
     * @return OK: true, NG: false
     */
    function send()
    {
    }

    /**
     * 顼åȽ
     *
     * @access public
     * @return string 顼å
     */
    function isError()
    {
        return ($this->error_message != '');
    }

    /**
     * 顼å
     *
     * @access public
     * @return string 顼å
     */
    function getErrorMessage()
    {
        return $this->error_message;
    }
}

?>
