<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilUseragent.php,v 1.5 2007/12/29 09:15:29 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * [U[G[WFgNX
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilUseragent.php,v 1.5 2007/12/29 09:15:29 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_UtilUserAgent
{
    /**
     * [U[G[WFg
     *
     * @access private
     * @var string
     */
    var $user_agent = '';

    /**
     * vbgtH[iOSjzi}X^j
     *
     * @access private
     * @var array
     */
    var $platforms = array(
      'Windows NT 6.0'  => 'Windows Vista',
      'Windows NT 5.2'  => 'Windows 2003 or XP x64',
      'Windows NT 5.1'  => 'Windows XP',
      'Windows NT 5.01' => 'Windows 2000 (Service Pack 1)',
      'Windows NT 5.0'  => 'Windows 2000',
      'Windows NT 4.0'  => 'Windows NT 4.0',
      'winnt4.0'        => 'Windows NT 4.0',
      'winnt 4.0'       => 'Windows NT',
      'winnt'           => 'Windows NT',
      'windows 98'      => 'Windows 98',
      'win98'           => 'Windows 98',
      'windows 95'      => 'Windows 95',
      'win95'           => 'Windows 95',
      'windows ce'      => 'Windows CE',
      'windows'         => 'Unknown Windows OS',
      'mac os x'        => 'Mac OS X',
      'mac os'          => 'Mac OS',
      'ppc mac'         => 'Mac OS',
      'Macintosh'       => 'Mac OS',
      'FreeBSD'         => 'FreeBSD',
      'Debian'          => 'Debian Linux',
      'SunOS'           => 'Sun Solaris',
      'beos'            => 'BeOS',
      'aix'             => 'AIX',
      'irix'            => 'Irix',
      'hp-ux'           => 'HP-UX',
      'netbsd'          => 'NetBSD',
      'openbsd'         => 'OpenBSD',
      'Fedora'          => 'Fedora Core',
      'CentOS'          => 'CentOS',
      'gnu'             => 'GNU/Linux',
      'vine'            => 'Vine Linux',
      'linux'           => 'Linux',
      'unix'            => 'Unknown Unix OS',

      'Nintendo Wii'     => 'Wii',
      'PS2; PlayStation' => 'PlayStation 2',
      'PLAYSTATION 3'    => 'PlayStation 3',
      'Dreampassport'    => 'DreamCast'
    );

    /**
     * uEUz
     *
     * @access private
     * @var array
     */
    var $browsers = array(
      'Opera'             => 'Opera',
      'Lunascape'         => 'Lunascape',
      'Sleipnir'          => 'Sleipnir',
      'MSIE'              => 'Internet Explorer',
      'Internet Explorer' => 'Internet Explorer',
      'Shiira'            => 'Shiira',
      'Firefox'           => 'Firefox',
      'Firebird'          => 'Firebird(Firefox)',
      'Chimera'           => 'Chimera',
      'Phoenix'           => 'Phoenix',
      'Camino'            => 'Camino',
      'Netscape'          => 'Netscape',
      'Safari'            => 'Safari',
      'IBrowse'           => 'IBrowse',
      'icab'              => 'iCab',
      'Konqueror'         => 'Konqueror',
      'hotjava'           => 'HotJava',
      'Lynx'              => 'Lynx',
      'jig browser'       => 'jig browser',

      'sharp pda browser' => 'ZAURUS',
      'AVE-Front'         => 'AVE-Front',
      'NetFront'          => 'NetFront',
      'UP.Browser'        => 'UP.Browser',
      'L-mode'            => 'L-mode',

      'Dreampassport'     => 'Dreampassport',

      'OmniWeb'           => 'OmniWeb',
      'WebCapture'        => 'Adobe Acrobat',
      'Mozilla'           => 'Mozilla',
      'W3C'               => 'W3C Validator',
      'Wget'              => 'Wget'
    );

    /**
     * oCLAzi}X^j
     *
     * @access private
     * @var array
     */
    var $carriers = array(
      'DoCoMo'     => 'DoCoMo',
      'J-PHONE'    => 'SoftBank',
      'Vodafone'   => 'SoftBank',
      'SoftBank'   => 'SoftBank',
      'MOT-'       => 'SoftBank',
      'KDDI-'      => 'KDDI(au)',
      'UP.Browser' => 'KDDI(au)',
      'WILLCOM'    => 'WILLCOM',
      'DDIPOCKET'  => 'WILLCOM',
      'PDXGW'      => 'WILLCOM'
    );

    /**
     * ROBOTzi}X^j
     *
     * @access private
     * @var array
     */
    var $robots = array(
      'Googlebot-Image'  => 'Googlebot-Image',
      'Googlebot-Mobile' => 'Googlebot-Mobile',
      'Googlebot'        => 'Googlebot',
      'Yahoo-MMCrawler'  => 'Yahoo-MMCrawler',
      'Yahoo! Slurp'     => 'Yahoo! Slurp',
      'Y!J-'             => 'Y!J',
      'msnbot-NewsBlogs' => 'msnbot-NewsBlogs',
      'msnbot-media'     => 'msnbot-media',
      'msnbot'           => 'msnbot',
      'Yeti'             => 'YetiBot',
      'Baiduspider'      => 'Baiduspider',
      'boitho.com-dc'    => 'boitho.com-dc',
      'blogoonbot'       => 'blogoonbot',
      'Comaneci_bot'     => 'Comaneci_bot',
      'e-SocietyRobot'   => 'e-SocietyRobot',
      'Gaisbot'          => 'Gaisbot',
      'GurujiBot'        => 'GurujiBot',
      'ICC-Crawler'      => 'ICC-Crawler',
      'ichiro'           => 'ichiro',
      'InfoSeek Sidewinder' => 'InfoSeek Sidewinder',
      'IDBot'         => 'IDBot',
      'IRLbot'        => 'IRLbot',
      'Jyxobot'       => 'Jyxobot',
      'Keywalkerbot'  => 'Keywalkerbot',
      'Modiphibot'    => 'Modiphibot',
      'MaplogCrawler' => 'MaplogCrawler',
      'MaSagool'      => 'MaSagool',
      'MJ12bot'       => 'MJ12bot',
      'multicrawler'  => 'multicrawler',
      'NaverBot'      => 'NaverBot',
      'Nutch'         => 'Nutch',
      'mootercrawler' => 'mootercrawler',
      'psbot'         => 'psbot',
      'RedBot'        => 'RedBot',
      'Robo Crawler'  => 'Robo Crawler',
      'Snapbot'       => 'Snapbot',
      'Steeler'       => 'Steeler',
      'SurveyBot'     => 'SurveyBot',
      'YodaoBot'      => 'YodaoBot',
      'TurnitinBot'   => 'TurnitinBot',
      'Twiceler-'     => 'Twiceler',
      'Vajradhara'    => 'Vajradhara',
      'WebGenBot'     => 'WebGenBot'
    );

    /**
     * RXgN^
     *
     * @access public
     * @param string [U[G[WFg
     */
    function SyL_UtilUserAgent($user_agent='')
    {
        if ($user_agent) {
            $this->user_agent = $user_agent;
        } else {
            $this->user_agent = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : '';
        }
    }

    /**
     * oCs
     *
     * @access public
     * @return bool true: oCAfalse: oCȊO
     */
    function isMobile()
    {
        return ($this->getCarrier() !== null);
    }

    /**
     * {bgs
     *
     * @access public
     * @return bool true: {bgAfalse: {bgȊO
     */
    function isRobot()
    {
        return ($this->getRobot() !== null);
    }

    /**
     * vbgtH[iOSj擾
     *
     * @access public
     * @return string vbgtH[iOSj
     */
    function getPlatform()
    {
        foreach ($this->platforms as $key => $value) {
            if (stristr($this->user_agent, $key) !== false) {
                return $value;
            }
        }
        return null;
    }

    /**
     * uEU擾
     *
     * @access public
     * @return string uEU
     */
    function getBrowser()
    {
        foreach ($this->browsers as $key => $value) {
            $reg = '/' . preg_quote($key, '/') . '[ |\/]?([0-9\.\/]+)?.*/i';
            if (preg_match($reg, $this->user_agent, $matches)) {
                return isset($matches[1]) ? $value . ' ' . $matches[1] : $value;
            }
        }
        return null;
    }

    /**
     * LA擾
     *
     * @access public
     * @return string LA
     */
    function getCarrier()
    {
        foreach ($this->carriers as $key => $value) {
            if (stristr($this->user_agent, $key) !== false) {
                return $value;
            }
        }
        return null;
    }

    /**
     * oC̋@햼擾
     *
     * @access public
     * @return string oC̋@햼
     */
    function getMobileModel()
    {
        switch ($this->getCarrier()) {
        case 'DoCoMo':
            // jDoCoMo/1.0/D505i/c20/TB/W20H10/serNMAIA000001
            if (preg_match('/^DoCoMo\/\d\.0\/([^\/]+)\/(.*)$/i', $this->user_agent, $matches)) {
                return $matches[1];
            // jDoCoMo/2.0 F900i(c100;TC;W22H12)
            } else if (preg_match('/^DoCoMo\/\d\.0[ ]*([^\(]+)(.*)$/i', $this->user_agent, $matches)) {
                return $matches[1];
            }
            break;
        case 'KDDI(au)':
            // jKDDI-HI32 UP.Browser/6.2.0.6.2 (GUI) MMP/2.0
            //     UP.Browser/3.04-ST13 UP.Link/3.4.5.9
            if (preg_match('/^([^\-]+)\-([^ ]+) (.+)$/i', $this->user_agent, $matches)) {
                return $matches[2];
            }
            break;
        case 'SoftBank':
            if (isset($_SERVER['HTTP_X_JPHONE_MSNAME'])) {
                return $_SERVER['HTTP_X_JPHONE_MSNAME'];
            } else if (preg_match('/^MOT\-(C|V)980.+$/i', $this->user_agent, $matches)) {
                switch ($matches[1]) {
                case 'C': return '702sMO';
                case 'V': return '702MO';
                }
            // jSoftBank/1.0/910T/TJ001/SN*** Browser/NetFront/3.3 Profile/MIDP-2.0 Configuration/CLDC-1.1
            } else if (preg_match('/^([^\/]+)\/([^\/]+)\/([^\/]+)\/?(.*)$/i', $this->user_agent, $matches)) {
                return $matches[3];
            }
            break;
        case 'WILLCOM':
            // jMozilla/4.0 (compatible; MSIE 4.01; Windows CE; SHARP/WS003SH; PPC; 480x640)
            // jMozilla/3.0(WILLCOM;SANYO/WX310SA/2;1/1/C128) NetFront/3.3
            if (strpos($this->user_agent, 'PDXGW') !== false) {
                return 'EDGE LINK';
            } else if (preg_match('/^Mozilla\/\d\.0([^\/]+)\/([^;\/]+);(.*)$/i', $this->user_agent, $matches)) {
                return $matches[2];
            } else if (preg_match('/^Mozilla\/\d\.0([^\/]+)\/([^\/]+)\/(.*)$/i', $this->user_agent, $matches)) {
                return $matches[2];
            }
            break;
        }
        return null;
    }

    /**
     * {bg擾
     *
     * @access public
     * @return string {bg
     */
    function getRobot()
    {
        foreach ($this->robots as $key => $value) {
            $reg = '/' . preg_quote($key, '/') . '[ |\/]?([0-9\.\/]+)?.*/i';
            if (preg_match($reg, $this->user_agent, $matches)) {
                return isset($matches[1]) ? $value . ' ' . $matches[1] : $value;
            }
        }
        return null;
    }
}

?>
