<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: CreateTemplate.php,v 1.2 2007/08/27 06:00:04 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ƥץ졼ȥեݡͥȥ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: CreateTemplate.php,v 1.2 2007/08/27 06:00:04 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class CreateTemplate
{
    /**
     * ƥץ졼ȥե
     *
     * @access public
     * @param string ץȥǥ쥯ȥ
     * @param string ץꥱ̾
     * @param string ƥץ졼ȥե
     */
    function trigger($project_dir, $app_name, $template_file)
    {
        $template_dir = "{$project_dir}apps/{$app_name}/templates/";
        if (!is_dir($template_dir)) {
            if (!mkdir($template_dir, 0755)) {
                trigger_error("[SyL error] template directory can't create ({$template_dir})", E_USER_ERROR);
                exit;
            }
        }

        if (!is_array($template_file)) {
            $template_file = array($template_file);
        }

        for ($i=0; $i<count($template_file); $i++) {
            if (preg_match('/^(\\\\|\/)/', $template_file[$i])) {
                $template_file[$i] = substr($template_file[$i], 1);
            }
            $file = $template_dir . ucfirst($template_file[$i]) . '.html';
            $tmp = dirname($file) . '/';
            $create_dir = array();
            while (preg_match('/^' . preg_quote($template_dir, '/') . '/', $tmp)) {
                array_unshift($create_dir, $tmp);
                $tmp = dirname($tmp);
            }

            foreach ($create_dir as $dir) {
                if (!is_dir($dir)) {
                    echo "  creating directory {$dir}\n"; ob_flush();
                    mkdir($dir, 0755);
                }
            }

            echo "  copying file {$file}\n"; ob_flush();
            if (file_exists("{$project_dir}var/skel-templates/template.html")) {
                copy("{$project_dir}var/skel-templates/template.html", $file);
            } else {
                copy(SYL_PROJECT_DIR . '/var/skel-templates/template.html', $file);
            }
        }
    }
}

?>
