<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_CacheDb.php,v 1.2 2008/01/15 09:19:03 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * DB³ʸ
 */
if (!defined('SYL_DB_DSN_CACHE')) {
    if (!defined('SYL_DB_DSN')) {
        trigger_error("[SyL error] Undefined constant `SYL_DB_DSN' or `SYL_DB_DSN_CACHE'", E_USER_ERROR);
    }
    define('SYL_DB_DSN_CACHE', SYL_DB_DSN);
}

/**
 * DB饹
 */
require_once dirname(__FILE__) . '/../SyL_DB.php';

/**
 * DBå奯饹
 *
 * 
 * CREATE TABLE SYL_CACHE ( 
 *   cache_id      varchar(50) NOT NULL, 
 *   cache_expires int NOT NULL, 
 *   cache_data    text,
 *   PRIMARY KEY  (cache_id)
 * );
 * Τ褦ʥơ֥
 *
 * SYL_CACHE_DB_TABLE = 'SYL_CACHE:cache_id:cache_data:cache_expires'
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_CacheDb.php,v 1.2 2008/01/15 09:19:03 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_CacheDb extends SyL_Cache
{
    /**
     * DBͥ
     *
     * @access private
     * @var object
     */
    var $conn = null; 
    /**
     * åơ֥̾
     *
     * @access private
     * @var string
     */
    var $table;
    /**
     * åID̾
     *
     * @access private
     * @var string
     */
    var $id;
    /**
     * åǡ̾
     *
     * @access private
     * @var string
     */
    var $data;
    /**
     * å󥿥ॹץ̾
     *
     * @access private
     * @var string
     */
    var $timestamp;
    /**
     * åեγǧCRCղä뤫
     *
     * @access private
     * @var bool
     */
    var $crc = true;
    /**
     * åե򥷥ꥢ벽뤫
     *
     * @access private
     * @var bool
     */
    var $serial = true;


    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_CacheDb()
    {
        if (!defined('SYL_CACHE_DB_TABLE')) {
            trigger_error("[SyL error] Undefined constant `SYL_CACHE_DB_TABLE'", E_USER_ERROR);
        }
        // ơ֥ץѥƥ
        list($this->table, $this->id, $this->data, $this->timestamp) = explode(':', SYL_CACHE_DB_TABLE);
        // DB³
        $this->conn =& SyL_DB::getConnection(SYL_DB_DSN_CACHE);
        // Ĵ
        switch ($this->conn->field_case) {
        case CASE_UPPER:
            $this->id        = strtoupper($this->id);
            $this->data      = strtoupper($this->data);
            $this->timestamp = strtoupper($this->timestamp);
            break;
        case CASE_LOWER:
            $this->id        = strtolower($this->id);
            $this->data      = strtolower($this->data);
            $this->timestamp = strtolower($this->timestamp);
            break;
        }
    }

    /**
     * DBȤ³
     *
     * @access public
     */
    function close()
    {
        if ($this->conn != null) {
            $this->conn->close();
            $this->conn = null;
        }
    }

    /**
     * åι֤򹹿
     *
     * @access public
     * @param int (UNIX Time)
     * @return bool true: OKfalse: 顼
     */
    function setModifyTime($mtime=0)
    {
        if (!$mtime) {
            $mtime = time();
        }

        $key = $this->getKey();

        $sql  = "";
        $sql .= "UPDATE ";
        $sql .=   "{$this->table} ";
        $sql .= "SET ";
        $sql .=   "{$this->timestamp} = {$mtime} ";
        $sql .= "WHERE ";
        $sql .=   "{$this->id} = '{$key}' ";
        return $this->conn->exec($sql);
    }

    /**
     * åեι֤
     *
     * @access public
     * @return int (UNIX Time)
     */
    function getModifyTime()
    {
        $key = $this->getKey();

        $sql  = "";
        $sql .= "SELECT ";
        $sql .=   "{$this->timestamp} ";
        $sql .= "FROM ";
        $sql .=   "{$this->table} ";
        $sql .= "WHERE ";
        $sql .=   "{$this->id} = '{$key}' ";

        $this->conn->queryRef($sql, $result, 'one');
        return $result;
    }

    /**
     * åɤ߹
     *
     * @access public
     * @param bool å֤ͭ򹹿
     * @return mixed åǡ
     */
    function read($modify_time_update=false)
    {
        $key = $this->getKey();

        $sql  = "";
        $sql .= "SELECT ";
        $sql .=   "{$this->data}, ";
        $sql .=   "{$this->timestamp} ";
        $sql .= "FROM ";
        $sql .=   "{$this->table} ";
        $sql .= "WHERE ";
        $sql .=   "{$this->id} = '{$key}' ";

        $this->conn->queryRef($sql, $result, 'record');

        if ($result) {
            // åեOK
            $data  = $result[$this->data];
            $mtime = $result[$this->timestamp];

            // ֤κǾȽ
            if ($this->min_mtime > 0) {
                if ($mtime < $this->min_mtime) {
                    $this->delete();
                    return false;
                }
            }
            // ֤κȽ
            if ($this->max_mtime > 0) {
                if ($mtime > $this->max_mtime) {
                    $this->delete();
                    return false;
                }
            }

            // ֤ͭ
            $life_time = ($this->life_time > 0) ? $mtime + $this->life_time : null;

            if (($life_time === null) || ($life_time >= time())) {
                $hash = null;
                if ($this->crc) {
                    $hash = substr($data, 0, 32);
                    $data = substr($data, 32);
                }

                if (($hash === null) || ($hash == $this->getCrc($data))) {
                    if ($modify_time_update) {
                        $this->setModifyTime();
                    }
                    return $this->serial ? unserialize($data) : $data;
                } else {
                    $this->delete();
                    return false;
                }
            } else {
                // åͭڤ
                $this->delete();
                return false;
            }
        } else {
            // åե̵
            return false;
        }
    }

    /**
     * å¸
     *
     * @access public
     * @param mixed åǡ
     * @return bool true: ¸false: ¸顼
     */
    function write($data)
    {
        $key = $this->getKey();

        // ǡΥꥢ벽Ƚ
        if ($this->serial) {
            $data = serialize($data);
        }
        // CRCɲȽ
        if ($this->crc) {
            $data = $this->getCrc($data) . $data;
        }

        $sql  = "";
        $sql .= "INSERT INTO {$this->table} (";
        $sql .=   "{$this->id}, ";
        $sql .=   "{$this->timestamp}, ";
        $sql .=   "{$this->data} ";
        $sql .= ") VALUES ( ";
        $sql .=   "'{$key}', ";
        $sql .=   " " . time() . ", ";
        $sql .=   "'" . $this->conn->escape($data) . "' ";
        $sql .= ") ";

        return $this->conn->exec($sql);
    }

    /**
     * å
     * 
     * @access public
     * @return bool true: false: 顼
     */
    function delete()
    {
        $key = $this->getKey();

        $sql  = "";
        $sql .= "DELETE FROM ";
        $sql .=   "{$this->table} ";
        $sql .= "WHERE ";
        $sql .=   "{$this->id} = '{$key}' ";
        return $this->conn->exec($sql);
    }

    /**
     * åδڤ쥭å
     *
     * @access public
     */
    function clean()
    {
        $sql  = "";
        $sql .= "DELETE FROM ";
        $sql .=   "{$this->table} ";
        $sql .= "WHERE ";
        $sql .= "(" . time() . " > {$this->timestamp} + {$this->life_time}) ";
        if ($this->min_mtime > 0) {
            $sql .= "Or ({$this->timestamp} < {$this->min_mtime}) ";
        }
        if ($this->max_mtime > 0) {
            $sql .= "Or ({$this->timestamp} > {$this->max_mtime}) ";
        }
        $this->conn->exec($sql);
    }

    /**
     * åƺ
     *
     * @access public
     */
    function cleanAll()
    {
        $sql  = "";
        $sql .= "DELETE FROM ";
        $sql .=   "{$this->table} ";
        $this->conn->exec($sql);
    }

    /**
     * CRCɲȽե饰򥻥å
     * 
     * @access public
     * @param bool CRCɲȽե饰
     */
    function setCrc($flag)
    {
        $this->crc = (bool)$flag;
    }

    /**
     * CRCɲäǡ
     * 
     * @access public
     * @param string ǡ
     * @return string ϥå
     */
    function getCrc($data)
    {
        return sprintf('%+032d', crc32($data));
    }

    /**
     * ꥢ벽Ƚե饰򥻥å
     * 
     * @access public
     * @param bool ꥢ벽Ƚե饰
     */
    function setSerialize($flag)
    {
        $this->serial = (bool)$flag;
    }
}

?>
