<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebService.php,v 1.1 2008/02/02 14:40:45 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥꥯȥ饹
 */
require_once dirname(__FILE__) . '/WebService/SyL_WebServiceRequest.php';
/**
 * WEBӥ쥹ݥ󥹥饹
 */
require_once dirname(__FILE__) . '/WebService/SyL_WebServiceResponse.php';
/**
 * HTTP饤ȥ饹
 */
require_once dirname(__FILE__) . '/Http/SyL_HttpClient.php';

/**
 * WEBӥ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebService.php,v 1.1 2008/02/02 14:40:45 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebService
{
    /**
     * 饤ȥ󥳡
     *
     * @access protected
     * @var string
     */
    var $client_encode = '';
    /**
     * С󥳡
     *
     * @access protected
     * @var string
     */
    var $server_encode = 'UTF-8';
    /**
     * å奪֥
     *
     * @access protected
     * @var object
     */
    var $cache = null;

    /**
     * 󥹥ȥ饯
     * 
     * @access public
     */
    function SyL_WebService()
    {
        $internal_encode = mb_internal_encoding();
        if ($internal_encode) {
            $this->client_encode = $internal_encode;
        }
    }

    /**
     * WEBӥ¹ԥ饹Υ󥹥󥹼
     *
     * @static
     * @access public
     * @param string WEBӥ
     * @return object WEBӥ¹ԥ饹
     */
    function &factory($type)
    {
        $class_name = 'SyL_WebService' . str_replace('.', '_', ucfirst($type));
        include_once dirname(__FILE__) . '/WebService/' . $class_name . '.php';
        $service =& new $class_name();
        return $service;
    }

    /**
     * 饤ȥ󥳡ɤ򥻥åȤ
     *
     * @access public
     * @param string 饤ȥ󥳡
     */
    function setClientEncode($client_encode)
    {
        $this->client_encode = $client_encode;
    }

    /**
     * С󥳡ɤ򥻥åȤ
     *
     * @access public
     * @param string С󥳡
     */
    function setServerEncode($server_encode)
    {
        $this->server_encode = $server_encode;
    }

    /**
     * ѥ᡼򥨥󥳡ɤ
     *
     * @access public
     * @param string 󥳡ѥ᡼
     * @return string 󥳡ɸѥ᡼
     */
    function convertEncoding($value)
    {
        if ($this->client_encode && $this->server_encode) {
            $value = mb_convert_encoding($value, $this->server_encode, $this->client_encode);
        } else if ($this->server_encode) {
            $value = mb_convert_encoding($value, $this->server_encode);
        }
        return $value;
    }

    /**
     * å奪֥Ȥ򥻥åȤ
     *
     * @access public
     * @param object å奪֥
     */
    function setCache(&$cache)
    {
        $this->cache =& $cache;
    }

    /**
     * ꥯȤ
     * 
     * @access public
     * @return object ᡼å֥
     */
    function &sendRequest(&$request)
    {
        $type = $request->getRequestType();
        $ssl  = $request->isSsl();
        $host = $request->getRequestHost();
        $port = $request->getRequestPort();
        $path = $request->getRequestPath();
        $parameters = $request->gets();

        $response = null;
        $cache    = null;
        if ($this->cache !== null) {
            // Ȳ
            if (version_compare(PHP_VERSION, '5.0.0', '>=')) {
                $cache = unserialize(serialize($this->cache));
            } else {
                $cache = $this->cache;
            }

            $key = (string)$ssl.$host.$port.$path.print_r($parameters, true);
            $cache->setKey($key);
            $response = $cache->read();
            if ($response) {
                // åOK
                $cache = null;
                return $response;
            }
        }

        switch ($type) {
        case 'rest':
            $client =& new SyL_HttpClient($host, $port, $ssl);
            $http_request =& $client->createRequest($path, 'GET');
            foreach ($parameters as $name => $value) {
                $http_request->set($this->convertEncoding($name), $this->convertEncoding($value));
            }
            $http_response =& $client->sendRequest($http_request, $this->client_encode);
            $response = $this->createResponse($http_response->getResponseStatus(), $http_response->getResult(), $request->getResponseClass());
            break;
//        case 'xmlrpc':
//            break;
        default:
            trigger_error("[SyL error] Invalid request type ({$type})", E_USER_ERROR);
        }

        if ($cache !== null) {
            // å񤭹
            $cache->write($response);
        }

        return $response;
    }

    /**
     * WEBӥ쥹ݥ󥹥֥Ȥ
     * 
     * @access protected
     * @param string 쥹ݥ󥹥ơ
     * @param string 쥹ݥ󥹥ǡ
     * @param string 쥹ݥ󥹥饹̾
     * @return object WEBӥ쥹ݥ󥹥֥
     */
    function &createResponse($response_status, $result, $classname)
    {
        $response =& new $classname($response_status, $result, $this->server_encode, $this->client_encode);
        return $response;
    }
}

?>
