<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceRequest.php,v 1.1 2008/02/02 14:40:45 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ѥץѥƥ饹
 */
require_once dirname(__FILE__) . '/../Util/SyL_UtilProperty.php';

/**
 * WEBӥꥯȥ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceRequest.php,v 1.1 2008/02/02 14:40:45 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceRequest extends SyL_UtilProperty
{
    /**
     * ꥯȥ
     *
     * @access protected
     * @var string
     */
    var $type = 'rest';
    /**
     * SSL
     *
     * @access protected
     * @var bool
     */
    var $ssl = false;
    /**
     * WEBӥСΥۥ̾
     *
     * @access protected
     * @var string
     */
    var $host = '';
    /**
     * WEBӥСΥݡ
     *
     * @access protected
     * @var string
     */
    var $port = '80';
    /**
     * ¹URLѥ
     *
     * @access protected
     * @var string
     */
    var $path = '/';
    /**
     * 쥹ݥ󥹥饹̾
     *
     * @access protected
     * @var string
     */
    var $response_class = '';

    /**
     * 󥹥ȥ饯
     * 
     * @access public
     */
    function SyL_WebServiceRequest()
    {
    }

    /**
     * ꥯȥפ
     *
     * @access public
     * @return string ꥯȥ
     */
    function getRequestType()
    {
        return $this->type;
    }

    /**
     * SSLͭȽꤹ
     *
     * @access public
     * @return bool SSL̵ͭ
     */
    function isSsl()
    {
        return $this->ssl;
    }

    /**
     * ꥯȥۥȤ
     *
     * @access public
     * @return string ꥯȥۥ
     */
    function getRequestHost()
    {
        return $this->host;
    }

    /**
     * ꥯȥݡȤ
     *
     * @access public
     * @return string ꥯȥݡ
     */
    function getRequestPort()
    {
        return $this->port;
    }

    /**
     * ꥯȥѥ
     *
     * @access public
     * @return string ꥯȥѥ
     */
    function getRequestPath()
    {
        return $this->path;
    }

    /**
     * 쥹ݥ󥹥饹̾
     *
     * @access public
     * @return string 쥹ݥ󥹥饹̾
     */
    function getResponseClass()
    {
        return $this->response_class;
    }
}

?>
