<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_User.php,v 1.5 2008/03/29 06:11:46 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 桼饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_User.php,v 1.5 2008/03/29 06:11:46 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_User
{
    /**
     * ID
     *
     * @access private
     * @var string
     */
    var $user_id = null;
    /**
     * 桼IDѥ᡼̾
     * 
     * @access protected
     * @var string
     */
    var $userid_param_name = 'login_username';
    /**
     * ѥɥѥ᡼̾
     * 
     * @access protected
     * @var string
     */
    var $password_param_name = 'login_password';
    /**
     * ǧڻΥѥɥϥåˡ
     * array(CLIENT¦HASHˡ, SERVER¦HASHˡ)
     * 
     * @access protected
     * @var string
     */
    var $password_hash = array(null,null);

    /**
     * 󥹥ȥ饯
     * 
     * @access public
     */
    function SyL_User()
    {
    }

    /**
     * 桼ID򥻥å
     * 
     * @access public
     * @param string 桼ID
     */
    function setUserId($user_id)
    {
        $this->user_id = $user_id;
    }

    /**
     * 桼ID
     * 
     * @access public
     * @return string 桼ID
     */
    function getUserId()
    {
        return $this->user_id;
    }

    /**
     * Ƚ
     * 
     * @access public
     * @return bool true: Ѥߡfalse: ̤
     */
    function isLogin()
    {
        return ($this->user_id !== null);
    }

    /**
     * 桼IDѥ᡼̾򥻥å
     * 
     * @access public
     * @return string 桼IDѥ᡼̾
     */
    function getUserIdParamName()
    {
        return $this->userid_param_name;
    }

    /**
     * ѥɥѥ᡼̾򥻥å
     * 
     * @access public
     * @return string ѥɥѥ᡼̾
     */
    function getPasswordParamName()
    {
        return $this->password_param_name;
    }

    /**
     * ǧڻΥѥɥϥåˡ򥻥å
     * 
     * @access public
     * @return array ǧڻΥѥɥϥåˡ
     */
    function getPasswordHash()
    {
        return $this->password_hash;
    }

    /**
     * ˵ư륤٥
     * 
     * @access public
     * @param string 桼ID
     */
    function triggerLoginSuccess($user_id)
    {
    }

    /**
     * 󥨥顼˵ư륤٥
     * 
     * @access public
     * @param string 桼ID
     */
    function triggerLoginFailed($user_id)
    {
    }

    /**
     * Ȼ˵ư륤٥
     * 
     * @access public
     * @param string 桼ID
     */
    function triggerLogout($user_id)
    {
    }
}

?>
