<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FormElementDate.php,v 1.2 2008/05/21 17:22:47 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * եǥ롼ץ饹
 */
require_once 'SyL_FormElementGroup.php';

/**
 * ɽǥ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FormElementDate.php,v 1.2 2008/05/21 17:22:47 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_FormElementDate extends SyL_FormElementGroup
{
    /**
     * ե̾
     *
     * @access private
     * @var string
     */
    var $form_name = '';
    /**
     * Ǵ֤ζڤʸ
     *
     * @access private
     * @var string
     */
    var $separator = "&nbsp;/&nbsp;";

    /**
     * ե४֥Ȥ򥻥åȤ
     *
     * @access public
     * @param object ե४֥
     */
    function initGroup(&$form)
    {
        $this->form_name = $form->getAttribute('name');

        $y_name = $this->attributes['year'];
        $m_name = $this->attributes['month'];
        $d_name = $this->attributes['day'];

        $selected_year = $form->getParameter($y_name);
        $selected_month = $form->getParameter($m_name);
        $selected_day   = $form->getParameter($d_name);

        if (is_array($selected_year)  && (count($selected_year) > 0))  $selected_year  = $selected_year[0];
        if (is_array($selected_month) && (count($selected_month) > 0)) $selected_month = $selected_month[0];
        if (is_array($selected_day)   && (count($selected_day) > 0))   $selected_day   = $selected_day[0];

        $years  = array('' => '----');
        $months = array('' => '--');
        $days   = array('' => '--');

        $years += $this->options;
        if ($selected_year) {
            for ($i=1; $i<=12; $i++) {
                $tmp = ($i < 10) ? '0' . $i : (string)$i;
                $months[$tmp] = $tmp;
            }
            if ($selected_month) {
                $max_day = date('t', mktime(0, 0, 0, $selected_month, 1, $selected_year));
                for ($i=1; $i<=$max_day; $i++) {
                    $tmp = ($i < 10) ? '0' . $i : (string)$i;
                    $days[$tmp] = $tmp;
                }
            }
        }

        $attributes = array();
        $attributes['onChange']  = '';
        $attributes['onChange'] .= "SyL.UI.Form.Util.changeDate(";
        $attributes['onChange'] .= "this.form.elements[\"{$y_name}[]\"],";
        $attributes['onChange'] .= "this.form.elements[\"{$m_name}[]\"],";
        $attributes['onChange'] .= "this.form.elements[\"{$d_name}[]\"],";
        $attributes['onChange'] .= "this.form.elements[\"{$y_name}[]\"].options[this.form.elements[\"{$y_name}[]\"].selectedIndex].value,";
        $attributes['onChange'] .= "this.form.elements[\"{$m_name}[]\"].options[this.form.elements[\"{$m_name}[]\"].selectedIndex].value,";
        $attributes['onChange'] .= "this.form.elements[\"{$d_name}[]\"].options[this.form.elements[\"{$d_name}[]\"].selectedIndex].value";
        $attributes['onChange'] .= ")";

        $this->addElement($form->createElement('select', $y_name, $this->getDisplayName(), $years,  $attributes));
        $this->addElement($form->createElement('select', $m_name, $this->getDisplayName(), $months, $attributes));
        $this->addElement($form->createElement('select', $d_name, $this->getDisplayName(), $days,   $attributes));

        $this->setSeparator($this->separator);
    }

    /**
     * Ǵ֤ζڤʸ򥻥å
     *
     * @access public
     * @param string Ǵ֤ζڤʸ
     */
    function setSeparator($separetor)
    {
        $this->separator = $separetor;

        $format = '%s' . $this->separator . '%s' . $this->separator . '%s';
        $this->setFormat($format, $this->attributes['year'], $this->attributes['month'], $this->attributes['day']);
    }
}

?>
