/**
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id:$
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

if (!SyL) var SyL = {};
if (!SyL.Ajax) SyL.Ajax = {};

/**
 * Ajax̿饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id:$
 * @link      http://www.syl.jp/
 */
SyL.Ajax.Process = function()
{
  this.initialize();
}

SyL.Ajax.Process.prototype = {
  initialize: function()
  {
    var method = 'GET';
    var async  = true;
    var loadingCallback = null;
    var completeCallback  = null;
    var timeoutCallback  = null;
    var errorCallback  = null;
    var callback_parameter_name = "callback";
    var parameters  = {};
    var request     = getXMLHttpObject();
    var timeout     = 30000;
    var timeoutTimer = null;

    var self = this;

    this.setMethod = function(methodt)
    {
      if (methodt && (typeof(methodt) == "string")) {
        methodt = methodt.toUpperCase();
        if ((methodt == "GET") || (methodt == "POST")) {
          method = methodt;
          return;
        }
      }
      throw "[SyL.Ajax.Process.setMethod] Invalid method parameter (" + methodt + ")";
    };
    this.setAsync = function(asynct)
    {
      if (typeof(asynct) == "boolean") {
        async = asynct;
      } else {
        throw "[SyL.Ajax.Process.setAsync] Invalid method parameter (" + asynct + ")";
      }
    };
    this.setLoadingCallback = function(callback)
    {
      if (typeof(callback) == "function") {
        loadingCallback = callback;
      } else {
        throw "[SyL.Ajax.Process.setLoadingCallback] Invalid parameter format(" + typeof(callback) + ")";
      }
    };
    this.setCompleteCallback = function(callback)
    {
      if ((typeof(callback) == "function") || 
          (typeof(callback) == "string")) {
        completeCallback = callback;
      } else {
        throw "[SyL.Ajax.Process.setCompleteCallback] Invalid parameter format(" + typeof(callback) + ")";
      }
    };
    this.setTimeoutCallback = function(callback)
    {
      if (typeof(callback) == "function") {
        timeoutCallback = callback;
      } else {
        throw "[SyL.Ajax.Process.setTimeoutCallback] Invalid parameter format(" + typeof(callback) + ")";
      }
    };
    this.setErrorCallback = function(callback)
    {
      if (typeof(callback) == "function") {
        errorCallback = callback;
      } else {
        throw "[SyL.Ajax.Process.setErrorCallback] Invalid parameter format(" + typeof(callback) + ")";
      }
    };
    this.callbackParameterName = function(callback_parameter_namet)
    {
      if (typeof(callback_parameter_namet) == "string") {
        callback_parameter_name = callback_parameter_namet;
      } else {
        throw "[SyL.Ajax.Process.callbackParameterName] Invalid method parameter (" + callback_parameter_name + ")";
      }
    };
    this.setTimeout = function(timeoutt)
    {
      if (typeof(timeoutt) == "number") {
        timeout = timeoutt;
      } else {
        throw "[SyL.Ajax.Process.setTimeout] Invalid method parameter (" + timeoutt + ")";
      }
    };
    this.addParameter = function(key, value)
    {
      parameters[key] = value;
    };
    function getXMLHttpObject()
    {
      var request = null;
      if (window.ActiveXObject) {
        try {
          request = new ActiveXObject("Msxml2.XMLHTTP");
        } catch(e) {
          try {
            request = new ActiveXObject("Microsoft.XMLHTTP");
          } catch(e) {
            request = null;
          }
        }
      } else if (window.XMLHttpRequest) {
        try {
          request = new XMLHttpRequest();
        } catch(e) {
          request = null;
        }
        if (request.overrideMimeType) {
          request.overrideMimeType('text/plain');
        }
      }

      if (request == null) {
        throw "XMLHTTP object not implemented in browser";
      }

      return request;
    };

    this.sendRequest = function(url)
    {
      if (completeCallback == null) {
        throw 'undefined comlete callback function';
      }

      var parameter = '';
      for (var key in parameters) {
        if (parameter != '') {
          parameter += '&';
        }
        parameter += encodeURIComponent(key) + "=" + encodeURIComponent(parameters[key]);
      }

      if (typeof(loadingCallback) == "string") {
        if (!loadingCallback.match(/^[a-zA-Z0-9_\.\$\[\]]+$/)) {
          throw "Invalid Loading Function name";
        }
        loadingCallback = eval('(' + loadingCallback + ')');
      }

      if ((url.substr(0, 7) == "http://")  ||
          (url.substr(0, 8) == "https://") ||
          (url.substr(0, 2) == "//")) {
        // for JSONP
        if (typeof(completeCallback) != "string") {
          throw "Invalid complete callback name. JSONP is string only.";
        } else if (!completeCallback.match(/^[a-zA-Z0-9_\.\$\[\]]+$/)) {
          throw "Invalid complete callback name";
        }

        if (method == 'POST') {
          var id = '__syl_ajax_id';
          var i = 0;
          while (true) {
            if (!document.getElementById(id + i)) {
              id = id + i;
              break;
            }
          }

          var div = document.createElement('div');
          div.innerHTML = '<iframe src="javascript:false;" style="display:none" id="' + id + '" name="' + id + '"></iframe>';
          document.body.appendChild(div);

          var form_id = id + "_form";
          var form = document.createElement('form');
          form.method = method;
          form.target = id;
          form.action = url;
          form.name   = form_id;
          form.id     = form_id;

          for (var key in parameters) {
            var input   = document.createElement("input");
            input.type  = "hidden";
            input.name  = key;
            input.value = parameters[key];
            form.appendChild(input);
          }
          var input   = document.createElement("input");
          input.type  = "hidden";
          input.name  = callback_parameter_name;
          input.value = completeCallback;
          form.appendChild(input);

          document.body.appendChild(form);
          document.forms[form_id].submit();
        } else {
          if (parameter != '') {
            parameter += '&';
          }
          parameter += callback_parameter_name + "=" + encodeURIComponent(completeCallback);
          var script     = document.createElement('script');
          script.type    = "text/javascript";
          script.charset = "UTF-8";
          script.src     = url + '?' + parameter;
          document.lastChild.appendChild(script);
        }
      } else {
        // for JSON
        if (typeof(completeCallback) == "string") {
          if (!completeCallback.match(/^[a-zA-Z0-9_\.\$\[\]]+$/)) {
            throw "Invalid completeCallback Function name";
          }
          completeCallback = eval('(' + completeCallback + ')');
        }

        var timeoutTimer = null;
        request.onreadystatechange = function(e) {
          onReadyStateChange(request);
          if (timeoutTimer) {
            clearTimeout(timeoutTimer);
            timeoutTimer = null;
          }
          return false;
        };

        if (timeout > 0) {
          timeoutTimer = setTimeout(function(){
            clearTimeout(timeoutTimer);
            timeoutTimer = null;
            self.cancelRequest();
            if (timeoutCallback) {
              timeoutCallback();
            }
          }, timeout);
        }

        if (method == 'POST') {
          request.open(method, url, async);
          request.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8');
          request.send(parameter);
        } else {
          request.open(method, url + '?' + parameter, async);
          request.send(null);
        }
      }
    };

    function onReadyStateChange(request)
    {
      switch (request.readyState) {
      case 4:
        switch (request.status) {
        case 200:
          var data;
          if (request.getResponseHeader('Content-Type').match(/json/i)) {
              data = eval('(' + request.responseText + ')');
          } else {
              data = request.responseText;
          }
          if (typeof(completeCallback) == "function") {
              completeCallback(data);
          }
          break;
        case 301:
        case 306: // 301 ϥ֥饦٥ǥ쥯Ȥ뤿306
          var url = request.getResponseHeader('Location');
          if (url) {
            window.location.href = url;
          } else {
            alert('301 Moved Permanently. But Nothing Location header');
            if (typeof(completeCallback) == "function") {
              completeCallback(false);
            }
          }
          break;
        case 500:
          if (errorCallback) {
            errorCallback(request.status, request.responseText);
          } else {
            alert('500 Internal Server Error: \n' + request.responseText);
          }
          break;
        default:
          alert('Response Error: ' + request.status + ' ' + request.statusText);
        }
        break;
      default:
        if (typeof(loadingCallback) == "function") {
          loadingCallback();
        }
        break;
      }
    };

    this.cancelRequest = function()
    {
      if (typeof(request) == "object") {
        if (request.readyState && ((request.readyState != 0) || (request.readyState != 4))) {
          request.abort();
        }
        request = null;
      }
    };
  }
}

/**
 * Ajaxꥯȥ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id:$
 * @link      http://www.syl.jp/
 */
SyL.Ajax.Request = {
  sendSyncGet: function(url, callback, parameters)
  {
    SyL.Ajax.Request.send(url, {'callback': callback, 'async': false, 'method': 'GET', 'parameters': parameters});
  },
  sendSyncPost: function(url, callback, parameters)
  {
    SyL.Ajax.Request.send(url, {'callback': callback, 'async': false, 'method': 'POST', 'parameters': parameters});
  },
  sendAsyncGet: function(url, callback, parameters)
  {
    SyL.Ajax.Request.send(url, {'callback': callback, 'async': true, 'method': 'GET', 'parameters': parameters});
  },
  sendAsyncPost: function(url, callback, parameters)
  {
    SyL.Ajax.Request.send(url, {'callback': callback, 'async': true, 'method': 'POST', 'parameters': parameters});
  },

  send: function(url, arg)
  {
    if (!url) {
      alert('undefined url');
      return;
    }

    var ajax = new SyL.Ajax.Process();
    if (typeof(arg) == "object") {
      if (arg.callback) {
        if (typeof(arg.callback) == "object") {
          if ((typeof(arg.callback.complete) == "function") ||
              (typeof(arg.callback.complete) == "string")) {
            ajax.setCompleteCallback(arg.callback.complete);
          }
          if (typeof(arg.callback.loading) == "function") {
            ajax.setLoadingCallback(arg.callback.loading);
          }
          if (typeof(arg.callback.timeout) == "function") {
            ajax.setTimeoutCallback(arg.callback.timeout);
          }
          if (typeof(arg.callback.error) == "function") {
            ajax.setErrorCallback(arg.callback.error);
          }
        } else if ((typeof(arg.callback) == "function") ||
                   (typeof(arg.callback) == "string")) {
          ajax.setCompleteCallback(arg.callback);
        }
      }
      if (arg.method) {
        ajax.setMethod(arg.method);
      }
      if (typeof(arg.async) != "undefined") {
        ajax.setAsync(arg.async);
      }
      if (typeof(arg.parameters) == "object") {
        for (var i in arg.parameters) {
          ajax.addParameter(i, arg.parameters[i]);
        }
      }
    }
    ajax.sendRequest(url);
  }
}

/**
 * Ajaxץ쥹С饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id:$
 * @link      http://www.syl.jp/
 */
SyL.Ajax.ProgressBar = function(url, type, id, idp)
{
  this.initialize(url, type, id, idp);
}

SyL.Ajax.ProgressBar.prototype = {
  initialize: function(url, type, id, idp)
  {
    var idbar = [];
    var idbarPrefix = "_syl_bar_" + id + "_";
    var processing = false;
    var progressColor = "#0B2467";
    var separate = 10;
    var completeCallbackFunc = null;

    switch (type) {
    case 'standard':
    case 'smooth':
      break;
    default:
      throw "[SyL.Ajax.ProgressBar] Invalid type parameter (" + type + ")";
      break;
    }

    this.setProgressColor = function(color)
    {
      progressColor = color;
    };
    this.setSeparate = function(separatet)
    {
      if (typeof(separatet) == "number") {
        separate = separatet;
      } else {
        throw "[SyL.Ajax.ProgressBar.setSeparate] Invalid method parameter (" + separatet + ")";
      }
    };
    this.setCompleteCallback = function(callback)
    {
      if (typeof(callback) == "function") {
        completeCallbackFunc = callback;
      } else {
        throw "[SyL.Ajax.ProgressBar.setCompleteCallback] Invalid callback parameter";
      }
    };
    this.start = function(resource)
    {
      create();

      var self = this;
      var loading = new SyL.Event.Loading(id + "_loading");
      loading.setLoadingCallback(function(){requestCallback();});
      loading.setCompleteCallback(function(){completeCallback();});
      loading.start(resource);

      processing = true;
    };
    function create()
    {
      if (processing) return;

      var div = document.getElementById(id);
      clear(div);

      switch (type) {
      case 'smooth': div.appendChild(createSmooth()); break;
      default:       div.appendChild(createStandard()); break;
      }
    };
    function clear(div)
    {
      if (document.getElementById(idp)) {
        document.getElementById(idp).innerHTML = "0%";
      }
      while (div.hasChildNodes()) div.removeChild(div.lastChild);
    };
    function createStandard()
    {
      var table = document.createElement("table");
      var tbody = document.createElement("tbody");
      var tr = document.createElement("tr");

      for (var i=0; i<separate; i++) {
        var tmp = idbarPrefix + i;
        var td = document.createElement("td");
        td.id = tmp;
        tr.appendChild(td);
        idbar.push(tmp);
      }
      tbody.appendChild(tr);
      table.appendChild(tbody);

      return table;
    };
    function createSmooth()
    {
      var table = document.createElement("table");
      var tbody = document.createElement("tbody");
      var tr  = document.createElement("tr");
      var td = document.createElement("td");

      var div = document.createElement("div");
      var tmp = idbarPrefix + "1";
      div.id  = tmp;
      div.style.width = "0%";
      div.style.backgroundColor = progressColor;
      div.style.display = "none";
      idbar.push(tmp);

      td.appendChild(div);
      tr.appendChild(td);
      tbody.appendChild(tr);
      table.appendChild(tbody);

      return table;
    };
    function requestCallback()
    {
       SyL.Ajax.Request.sendAsyncPost(
         url,
         function(result)
         {
           if (result.progress) {
             if (type == 'smooth') {
               if (result.progress > 0) {
                 document.getElementById(idbar[0]).style.display = "block";
                 document.getElementById(idbar[0]).style.width = result.progress + "%";
               }
             } else {
               var num   = idbar.length;
               var point = 100 / num;
               for (var i=0; i<num; i++) {
                 if (result.progress >= Math.ceil(point * (i+1))) {
                   document.getElementById(idbar[i]).style.backgroundColor = progressColor;
                 } else {
                   break;
                 }
               }
             }
             if (idp) {
               document.getElementById(idp).innerHTML = result.progress + "%";
             }
           }
         },
         {'finish': '0'}
       );
    };
    function completeCallback()
    {
       SyL.Ajax.Request.sendAsyncPost(
         url,
         function(result)
         {
           if (result.progress < 100) {
             alert("Request Timeout ? (" + result.progress + "% end)");
           }
           if (result.progress) {
             if (type == 'smooth') {
               document.getElementById(idbar[0]).style.width = result.progress + "%";
             } else {
               var num   = idbar.length;
               var point = 100 / num;
               for (var i=0; i<num; i++) {
                 if (result.progress >= Math.ceil(point * (i+1))) {
                   document.getElementById(idbar[i]).style.backgroundColor = "#0B2467";
                 } else {
                   break;
                 }
               }
             }
             if (idp) {
               document.getElementById(idp).innerHTML = result.progress + "%";
             }
           }
           if (completeCallbackFunc) {
             completeCallbackFunc();
           }
         },
         {'finish': '1'}
       );
      processing = false;
    };
  }
}

