<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Console.php,v 1.8 2008/07/10 15:17:43 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 *  󥽡ɽ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Console.php,v 1.8 2008/07/10 15:17:43 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Console
{
    /**
     * Ƭ
     *
     * @access private
     * @var string
     */
    var $shell_prefix = '> ';
    /**
     * ȤƼ¹ԤȤΰ
     * falseξϥޥɼ¹Բ
     *
     * @access private
     * @var string
     */
    var $shell_string = '\!';
    /**
     * ¹Ի˥ޥɥ饤λʸ
     *
     * @access private
     * @var array
     */
    var $exit_strings = array(
      'quit',
      'exit',
      '\q'
    );
    /**
     * ޥɥ饤ɽå
     *
     * [message]
     * [default_message] > 
     *
     * array(
     *   [0] => array( [message], [default_message] ),
     *   ...
     * );
     *
     * @access private
     * @var array
     */
    var $command_messages = array();
    /**
     * ޥɥ饤󤫤ͤ륳Хåؿ
     *
     * @access private
     * @var array
     */
    var $callback_func = array();
    /**
     * ɽѴ󥳡
     *
     * @access private
     * @var array
     */
    var $output_encode = '';
    /**
     * ץ¦Υ󥳡
     * 
     * @access protected
     * @var string
     */
    var $internal_encode = '';

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param string ɽѴ󥳡
     * @param string ץ¦󥳡
     */
    function SyL_Console()
    {
        $this->callback_func = array(&$this, 'doCallback');
    }

    /**
     * Ƭ򥻥åȤ
     *
     * @access public
     * @param string Ƭ
     */
    function setShellPrefix($shell_prefix)
    {
        $this->shell_prefix = $shell_prefix;
    }

    /**
     * ɽѴ󥳡ɤ򥻥åȤ
     *
     * @access public
     * @param string ɽѴ󥳡
     */
    function setOutputEncode($output_encode)
    {
        $this->output_encode = $output_encode;
    }

    /**
     * ץ¦󥳡ɤ򥻥åȤ
     *
     * @access public
     * @param string ץ¦󥳡
     */
    function setInternalEncode($internal_encode)
    {
        $this->internal_encode = $internal_encode;
    }

    /**
     * λʸɲä
     *
     * @access public
     * @param string λʸ
     */
    function addExitString($exit_string)
    {
        $this->exit_strings[] = $exit_string;
    }

    /**
     * ʸѹ
     * falseξϥޥɼ¹Բ
     *
     * @access public
     * @param string ʸ
     */
    function setShellString($shell_string)
    {
        $this->shell_string = $shell_string;
    }

    /**
     * ¹ѡɽå򥻥å
     *
     * @access public
     * @param string ɽå
     * @param string ޥ­å
     */
    function addMessage($message, $message_default='')
    {
        $this->command_messages[] = array($message, $message_default);
    }

    /**
     * ¹ѡޥɥ饤󤫤ͤ륳Хåؿ򥻥å
     *
     * @access public
     * @param mixed Хåؿ
     */
    function setCallbackFunc($callback_func)
    {
        if (is_callable($callback_func)) {
            $this->callback_func = $callback_func;
        } else {
            trigger_error("[SyL error] invalid callable format", E_USER_ERROR);
        }
    }

    /**
     * ǥեȥХåؿ
     *
     * @access public
     * @param string 
     */
    function doCallback(&$console, $return, $shell)
    {
    }

    /**
     * ¹ԥ
     *
     * @access public
     * @param bool ޥɥ롼ץե饰
     */
    function start($loop=false)
    {
        while (true) {
            $shell = '';
            if ($this->command_messages) {
                $command_message = array_shift($this->command_messages);
                $return = $this->getInput($command_message[0], $command_message[1]);
            } else {
                if (!$loop) {
                    break;
                }
                $return = $this->getInput('');
            }
            if (in_array($return, $this->exit_strings)) {
                break;
            }
            if ($this->shell_string && (substr($return, 0, strlen($this->shell_string)) == $this->shell_string)) {
                $shell = shell_exec(substr($return, strlen($this->shell_string)));
            }
            // Хåؿ¹
            call_user_func_array($this->callback_func, array(&$this, $return, $shell));
        }
    }

    /**
     * ɽϤ
     *
     * @access public
     * @param string ɽå
     * @param bool ԥե饰
     */
    function stdout($message, $newline=true)
    {
        $this->stdmessage($message, 'out', $newline);
    }

    /**
     * 顼ɽϤ
     *
     * @access public
     * @param string 顼ɽå
     * @param bool ԥե饰
     */
    function stderr($message, $newline=true)
    {
        $this->stdmessage($message, 'err', $newline);
    }

    /**
     * ɽϤ
     *
     * @access public
     * @param string ɽå
     * @param string ɽ
     * @param bool ԥե饰
     */
    function stdmessage($message, $type='out', $newline=true)
    {
        if ($this->output_encode) {
            if ($this->internal_encode) {
                $message = mb_convert_encoding($message, $this->output_encode, $this->internal_encode);
            } else {
                $message = mb_convert_encoding($message, $this->output_encode);
            }
        }
        if ($newline) {
            $message .= "\n";
        }
        if ($type == 'err') {
            fwrite(STDERR, $message);
        } else {
            fwrite(STDOUT, $message);
        }
        ob_flush();
    }

    /**
     * ͤ
     *
     * @access public
     * @param string ɽå
     * @param string ޥ­å
     */
    function getInput($message, $message_default='')
    {
        if ($message_default != '') {
            $message_default .= ' ';
        }
        $message_default .= $this->shell_prefix;
        if ($message) {
            $this->stdout($message);
        }
        $this->stdout($message_default, false);
        ob_flush();

        return trim(fgets(STDIN,256));
    }
}

?>
