<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidationValidatorEmail.php,v 1.4 2008/05/21 17:22:47 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ᡼륢ɥ쥹ڥ饹
 * 
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidationValidatorEmail.php,v 1.4 2008/05/21 17:22:47 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ValidationValidatorEmail extends SyL_ValidationValidator
{
    /**
     * ᡼륢ɥ쥹ڽ¹Ԥ
     *
     * @access public
     * @param string о
     * @return bool true: 顼̵, false: 顼
     */
    function validate($value)
    {
        $format = '/^[\w\-]+([\w\-\.]+[\w\-]+)?@[\w\-]+([\w\-\.]+)?\.[a-zA-Z]{2,}$/';
        return preg_match($format, $value);
    }

    /**
     * ᡼륢ɥ쥹ڽJavaScript
     *
     * @access public
     * @return string JavaScriptå
     */
    function getJsCode()
    {
        $format = '/^[\w\-]+([\w\-\.]+[\w\-]+)?@[\w\-]+([\w\-\.]+)?\.[a-zA-Z]{2,}$/';
        $options = array();
        $options[] = "'format': {$format}";
        $options[] = "'min_valids': '{$this->min_valids}'";
        $options[] = "'max_valids': '{$this->max_valids}'";

        $js  = '';
        $js .= 'var message_tmp = validation.isRegex(name, "' . $this->getErrorMessage() . '", {' . implode(',', $options) . '});' . "\n";
        $js .= 'if (message_tmp) {' . "\n";
        $js .= '  message = message_tmp;' . "\n";
        $js .= '}' . "\n";
        return $js;
    }
}

?>
