<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidationValidatorFile.php,v 1.5 2008/05/21 17:22:47 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ե륢åץɸڥ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidationValidatorFile.php,v 1.5 2008/05/21 17:22:47 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ValidationValidatorFile extends SyL_ValidationValidator
{
    /**
     * ѥ᡼
     *
     * @access protected
     * @var array
     */
    var $parameters = array(
      'name_format'       => null,
      'name_format_error' => null,
      'min'               => 1, // 
      'min_error'         => null,
      'max'               => null, // checkbox, select, fileκå
      'max_error'         => null,
      'mime_format'       => null, // mime typeɽǸ
      'mime_format_error' => null,
      'is_upload'         => true, // is_uploaded_fileؿǸ
      'is_upload_error'   => null
    );

    /**
     * ڽ¹Ԥ
     *
     * @access public
     * @param string о
     * @param string о̾
     * @return bool true: 顼̵, false: 顼
     */
    function execute($value, $name='')
    {
        if ($value === null) {
            // ե륢åץɰʳϡåʤ
            return true;
        }

        // ɬܥå or եåʳǡͤξtrue
        if (!$this->isRequire()) {
            if (!call_user_func(array(__CLASS__, 'executeImmediate'), 'requirefile', $value)) {
                return true;
            }
        }

        if (!$this->validate($value)) {
            $this->replaceErrorMessage($name);
            return false;
        } else {
            return true;
        }
    }

    /**
     * ե륢åץɸڽ¹Ԥ
     *
     * @access public
     * @param array о
     * @return bool true: 顼̵, false: 顼
     */
    function validate($value)
    {
        sort($value['size'], SORT_NUMERIC);
        // Ǿͥå
        if ($this->parameters['min'] !== null) {
            if ($value['size'][0] < $this->parameters['min']) {
                if ($this->parameters['min_error'] !== null) {
                    $this->error_message = $this->parameters['min_error'];
                }
                return false;
            }
        }
        // ͥå
        if ($this->parameters['max'] !== null) {
            if ($value['size'][count($value['size'])-1] > $this->parameters['max']) {
                if ($this->parameters['max_error'] !== null) {
                    $this->error_message = $this->parameters['max_error'];
                }
                return false;
            }
        }
        // ե̾å
        if ($this->parameters['name_format'] !== null) {
            foreach ($value['name'] as $tmp) {
                if (!preg_match($this->parameters['name_format'], $tmp)) {
                    if ($this->parameters['name_format_error'] !== null) {
                        $this->error_message = $this->parameters['name_format_error'];
                    }
                    return false;
                }
            }
        }
        // MIMEץå
        if ($this->parameters['mime_format'] !== null) {
            foreach ($value['type'] as $tmp) {
                if (!preg_match($this->parameters['mime_format'], $tmp)) {
                    if ($this->parameters['mime_format_error'] !== null) {
                        $this->error_message = $this->parameters['mime_format_error'];
                    }
                    return false;
                }
            }
        }
        // POSTå
        if ($this->parameters['is_upload'] !== null) {
            foreach ($value['tmp_name'] as $tmp) {
                if (!is_uploaded_file($tmp)) {
                    if ($this->parameters['is_upload_error'] !== null) {
                        $this->error_message = $this->parameters['is_upload_error'];
                    }
                    return false;
                }
            }
        }

        return true;
    }

    /**
     * ե̾ڽJavaScript
     *
     * @access public
     * @return string JavaScriptå
     */
    function getJsCode()
    {
        $format = $this->parameters['name_format'];

        $js  = '';
        if ($format) {
            $error_message = $this->parameters['name_format_error'];
            if (!$error_message) {
                $error_message = $this->getErrorMessage();
            }

            $options = array();
            $options[] = "'format': {$format}";
            $options[] = "'min_valids': '{$this->min_valids}'";
            $options[] = "'max_valids': '{$this->max_valids}'";

            $js  = '';
            $js .= 'var message_tmp = validation.isRegex(name, "' . $error_message . '", {' . implode(',', $options) . '});' . "\n";
            $js .= 'if (message_tmp) {' . "\n";
            $js .= '  message = message_tmp;' . "\n";
            $js .= '}' . "\n";
        }
        return $js;
    }

}

?>
