<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceAuctionAuctionItemCodeSearchRequest.php,v 1.1 2008/03/01 05:01:22 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹ʳŷ - ŷʥɸAPIѡ
 */
require_once 'SyL_WebServiceAuctionAuctionItemCodeSearchResponse.php';

/**
 * WEBӥ饹ʳŷ - ŷʥɸAPIѡ
 *
 * ܺ٤ϡŷ֥ӥ󥿡
 *   http://webservice.rakuten.co.jp/
 * ŷʥɸAPI
 *   http://webservice.rakuten.co.jp/api/auctionitemcodesearch/
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceAuctionAuctionItemCodeSearchRequest.php,v 1.1 2008/03/01 05:01:22 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceAuctionAuctionItemCodeSearchRequest extends SyL_WebServiceRakuten_co_jpRequest
{
    /**
     * ¹URLѥ
     *
     * @access protected
     * @var string
     */
    var $path = '/rws/1.10/rest';
    /**
     * 쥹ݥ󥹥饹̾
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceAuctionAuctionItemCodeSearchResponse';

    /**
     * С򥻥åȤ
     *
     * @access public
     * @param string С
     */
    function setVersion($version)
    {
        parent::set('version', $version);
    }

    /**
     * ʥɤ򥻥åȤ
     *
     * @access public
     * @param string ʥ
     */
    function setItemCode($itemCode)
    {
        parent::set('itemCode', $itemCode);
    }

    /**
     * ꥢ򥻥åȤ
     *
     * @access public
     * @param int ꥢ
     */
    function setCarrier($carrier)
    {
        switch ((string)$carrier) {
        case '0':
        case '1':
            parent::set('carrier', $carrier);
            break;
        default:
            trigger_error("[SyL error] Invalid `carrier' property ({$carrier}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }
}

?>
