<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceAuctionCategoryTreeResponse.php,v 1.1 2008/02/02 14:40:45 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹Yahoo! Japan -  - ƥѡ
 *
 * ܺ٤ϡYahoo!ǥ٥åѡͥåȥ
 *   http://developer.yahoo.co.jp/
 *  - ƥ
 *   http://developer.yahoo.co.jp/auctions/rest/categorytree/V1/categorytree.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceAuctionCategoryTreeResponse.php,v 1.1 2008/02/02 14:40:45 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceAuctionCategoryTreeResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * ƥID
     *
     * @access private
     * @var int
     */
     var $category_id = null;
    /**
     * ƥ̾
     *
     * @access private
     * @var string
     */
    var $category_name = null;
    /**
     * Ǿ̥ƥ꤫Υѥ
     *
     * @access private
     * @var string
     */
    var $category_path = null;
    /**
     * ƥƥΥѥ
     *
     * @access private
     * @var string
     */
    var $parent_category_path = null;
    /**
     * üƥȽ
     *
     * @access private
     * @var bool
     */
    var $is_leaf = false;
    /**
     * ҥƥ
     *
     * @access private
     * @var int
     */
    var $child_category_num = null;
    /**
     * ҥƥ
     *
     * @access private
     * @var array
     */
    var $child_category = array();

    /**
     * XMLǡƼϥɥ᥽å
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        static $category_i = -1;

        switch ($current_path) {
        // =============================
        // 
        // =============================
        // ƥID
        case '/category/categoryId': $this->category_id = $text; break;
        // ƥ̾
        case '/category/categoryName': $this->category_name = $text; break;
        // Ǿ̥ƥ꤫Υѥ
        case '/category/categoryPath': $this->category_path = $text; break;
        // ƥƥ꤫Υѥ
        case '/category/parentCategoryPath': $this->parent_category_path = $text; break;
        // üƥȽ
        case '/category/isLeaf': $this->is_leaf = ($text == 'true'); break;
        // ҥƥο
        case '/category/childCategoryNum': $this->child_category_num = $text; break;

        // ҥƥ
        case '/category/childCategory': $category_i++; break;
        // ҥƥID
        case '/category/childCategory/categoryId': $this->child_category[$category_i]['categoryId'] = $text; break;
        // ҥƥ̾
        case '/category/childCategory/categoryName': $this->child_category[$category_i]['categoryName'] = $text; break;
        // ҥƥΥʾʿ
        case '/category/childCategory/numOfAuctions': $this->child_category[$category_i]['numOfAuctions'] = $text; break;
        // üƥȽ
        case '/category/childCategory/isLeaf': $this->child_category[$category_i]['isLeaf'] = ($text == 'true'); break;

        // ¾
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }

    /**
     * ƥID
     *
     * @access public
     * @return int ƥID
     */
    function getCategoryId()
    {
        return $this->category_id;
    }

    /**
     * ƥ̾
     *
     * @access public
     * @return string ƥ̾
     */
    function getCategoryName()
    {
        return $this->category_name;
    }

    /**
     * Ǿ̥ƥ꤫Υѥ
     *
     * @access public
     * @return string Ǿ̥ƥ꤫Υѥ
     */
    function getCategoryPath()
    {
        return $this->category_path;
    }

    /**
     * ƥƥΥѥ
     *
     * @access public
     * @return string ƥƥΥѥ
     */
    function getParentCategoryPath()
    {
        return $this->parent_category_path;
    }

    /**
     * üƥȽ
     *
     * @access public
     * @return bool üƥȽ
     */
    function isLeaf()
    {
        return $this->is_leaf;
    }

    /**
     * ҥƥ
     *
     * @access public
     * @return int ҥƥ
     */
    function getChildCategoryNum()
    {
        return $this->child_category_num;
    }

    /**
     * ҥƥ
     *
     * @access public
     * @return array ҥƥ
     */
    function getChildCategory()
    {
        return $this->child_category;
    }
}

?>
