<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceKadenProductSearchResponse.php,v 1.1 2008/02/02 14:40:44 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹Yahoo! Japan - ʸѡ
 *
 * ܺ٤ϡYahoo!ǥ٥åѡͥåȥ
 *   http://developer.yahoo.co.jp/
 * ʸ
 *   http://developer.yahoo.co.jp/kaden/productsearch/v1/productsearch.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceKadenProductSearchResponse.php,v 1.1 2008/02/02 14:40:44 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceKadenProductSearchResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * ˰פʤ
     *
     * @access private
     * @var int 
     */
     var $total_products = 0;
    /**
     * ˰פڡ
     *
     * @access private
     * @var int 
     */
    var $total_page = 0;
    /**
     * ߤΥڡֹ
     *
     * @access private
     * @var int 
     */
    var $cur_page = 0;
    /**
     * ̥ǡ
     *
     * @access private
     * @var array
     */
    var $results = array();

    /**
     * XMLǡƼϥɥ᥽å
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i = -1;

        switch ($current_path) {
        // =============================
        // 
        // =============================
        case '/ProductResultSet':
            if (isset($attribute['totalProducts'])) {
                $this->total_products = $attribute['totalProducts'];
            }
            if (isset($attribute['totalPage'])) {
                $this->total_page = $attribute['totalPage'];
            }
            if (isset($attribute['curPage'])) {
                $this->cur_page = $attribute['curPage'];
            }
            break;
        case '/ProductResultSet/ProductResult': $i++; break;
        // IDʥץID
        case '/ProductResultSet/ProductResult/ProductID': $this->results[$i]['ProductID'] = $text; break;
        // ̾
        case '/ProductResultSet/ProductResult/ProductName': $this->results[$i]['ProductName'] = $text; break;
        // ȯ丵
        case '/ProductResultSet/ProductResult/MakerName': $this->results[$i]['MakerName'] = $text; break;
        // ƥ̾
        case '/ProductResultSet/ProductResult/CategoryName': $this->results[$i]['CategoryName'] = $text; break;
        // ʲURL
        case '/ProductResultSet/ProductResult/ImageUrl': $this->results[$i]['ImageUrl'] = $text; break;
        // ʾURL
        case '/ProductResultSet/ProductResult/ItemPageUrl': $this->results[$i]['ItemPageUrl'] = $text; break;
        // ǰ
        case '/ProductResultSet/ProductResult/LowestPrice': $this->results[$i]['LowestPrice'] = $text; break;
        // ߤΥڡURL
        case '/ProductResultSet/ProductResult/ReviewUrl': $this->results[$i]['ReviewUrl'] = $text; break;
        // ƿ
        case '/ProductResultSet/ProductResult/ReviewResults': $this->results[$i]['ReviewResults'] = $text; break;
        // ʿѺ
        case '/ProductResultSet/ProductResult/ReviewRating': $this->results[$i]['ReviewRating'] = $text; break;

        // ¾
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }

    /**
     * ʤ
     *
     * @access public
     * @return int ʤ
     */
    function getTotalProducts()
    {
        return $this->total_products;
    }

    /**
     * ڡ
     *
     * @access public
     * @return int ڡ
     */
    function getTotalPage()
    {
        return $this->total_page;
    }

    /**
     * ߤΥڡֹ
     *
     * @access public
     * @return int ߤΥڡֹ
     */
    function getCurPage()
    {
        return $this->cur_page;
    }

    /**
     * ̥ǡ
     *
     * @access public
     * @return array ̥ǡ
     */
    function getResults()
    {
        return $this->results;
    }
}

?>
