<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlXslt.php,v 1.1 2008/06/20 17:41:54 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ѥץѥƥ饹
 */
require_once dirname(__FILE__) . '/../Util/SyL_UtilProperty.php';

/** 
 * XSLTŬѥ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlXslt.php,v 1.1 2008/06/20 17:41:54 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_XmlXslt extends SyL_UtilProperty
{
    /**
     * XML
     *
     * @access private
     * @var string
     */
    var $xml = null;
    /**
     * XMLǡե饰
     *
     * @access private
     * @var bool
     */
    var $xml_data_flag = false;
    /**
     * XSL
     *
     * @access private
     * @var string
     */
    var $xsl = null;
    /**
     * XSLǡե饰
     *
     * @access private
     * @var bool
     */
    var $xsl_data_flag = false;
    /**
     * ƥץ졼ȤΥ󥳡
     * 
     * @access private
     * @var string
     */
    var $xslt_encode = 'UTF-8';
    /**
     * ѥ᡼󥳡
     * 
     * @access protected
     * @var string
     */
    var $internal_encode = '';
    /**
     * ϥ󥳡ǥѴե饰
     * 
     * @access protected
     * @var bool
     */
    var $output_convert_encoding = true;

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param string XSLե
     * @param string XMLե
     */
    function SyL_XmlXslt($xsl_file='', $xml_file='')
    {
        if ($xsl_file) $this->setXsl($xsl_file);
        if ($xml_file) $this->setXml($xml_file);
        $this->internal_encode = mb_internal_encoding();
    }

    /**
     * XMLե or ǡ򥻥å
     *
     * @access public
     * @param string XMLե or ǡ
     * @param bool ǡե饰
     */
    function setXml($xml, $data_flag=false)
    {
        $this->xml = $xml;
        $this->xml_data_flag = $data_flag;
    }

    /**
     * XSLե or ǡ򥻥å
     *
     * @access public
     * @param string XSLե or ǡ
     * @param bool ǡե饰
     */
    function setXsl($xsl, $data_flag=false)
    {
        if (!$data_flag) {
            // 1ܤ˥󥳡ǥ󥰤ä
            $fp = fopen($xsl, 'r');
            if (preg_match ('/<\?xml(.+)encoding=\"([^\"]+)\"(.*)\?>/i', fgets($fp, 4096), $matches)) {
                $this->setXsltEncode($matches[2]);
            }
            fclose($fp);
        }
        $this->xsl = $xsl;
        $this->xsl_data_flag = $data_flag;
    }

    /**
     * XSLT󥳡ɤ򥻥å
     *
     * @access public
     * @param string XSLT󥳡
     */
    function setXsltEncode($xslt_encode)
    {
        $this->xslt_encode = strtoupper($xslt_encode);
    }

    /**
     * ѥ᡼󥳡ɤ򥻥å
     *
     * @access public
     * @param string ѥ᡼󥳡
     */
    function setInternalEncode($internal_encode)
    {
        $this->internal_encode = strtoupper($internal_encode);
    }

    /**
     * ϥ󥳡ǥѴե饰򥻥å
     *
     * @access public
     * @param bool ϥ󥳡ǥѴե饰
     */
    function setOutputConvertEncoding($output_convert_encoding)
    {
        $this->output_convert_encoding = (bool)$output_convert_encoding;
    }

    /**
     * XSLTŬѤԤ
     * ϥեѥ᡼ꤷͤʤ
     *
     * @access public
     * @param string ϥե
     * @return mixed XSLTŬѸǡ
     */
    function transform($out_file=null)
    {
        if ($this->xslt_encode != $this->internal_encode) {
            $this->apply('mb_convert_encoding', $this->xslt_encode, $this->internal_encode);
        }

        $result = false;
        if (version_compare(PHP_VERSION, '5.0.0', '>=')) {
            $xslt = new XSLTProcessor();
            $doc  = new DOMDocument();

            if ($this->xsl_data_flag) {
                $doc->loadXML($this->xsl);
            } else {
                $doc->load($this->xsl);
            }
            $xslt->importStyleSheet($doc);

            if ($this->xml_data_flag) {
                $doc->loadXML($this->xml);
            } else {
                $doc->load($this->xml);
            }

            foreach ($this->gets() as $name => $value) {
                $xslt->setParameter('', $name, $value);
            }

            if ($out_file) {
                $result = $xslt->transformToURI($doc, $out_file);
            } else {
                $result = $xslt->transformToXML($doc);
            }
        } else {
            $xml  = '';
            $xsl  = '';
            $args = array();

            if ($this->xsl_data_flag) {
                $args['/_xsl'] = $this->xsl;
                $xsl = 'arg:/_xsl';
            } else {
                $xsl = $this->xsl;
            }

            if ($this->xml_data_flag) {
                $args['/_xml'] = $this->xml;
                $xml = 'arg:/_xml';
            } else {
                $xml = $this->xml;
            }

            $xslt = xslt_create();
            $result = xslt_process($xslt, $xml, $xsl, $out_file, $args, $this->gets());
            xslt_free($xslt);
        }

        if ($this->output_convert_encoding && is_string($result) && ($this->xslt_encode != $this->internal_encode)) {
            return mb_convert_encoding($result, $this->internal_encode, $this->xslt_encode);
        } else {
            return $result;
        }
    }

}

?>
