<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ActionForm.php,v 1.12 2008/06/20 17:41:54 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ե९饹
 */
require_once SYL_INCLUDE_DIR . '/lib/SyL_Form.php';

/**
 * ե९饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ActionForm.php,v 1.12 2008/06/20 17:41:54 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ActionForm extends SyL_Form
{
    /**
     * ե
     * 
     * @access protected
     * @var array
     */
    var $elements_config = array();

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param string URL
     * @param string ǽ
     */
    function SyL_ActionForm($action='')
    {
        parent::SyL_Form($action);
    }

    /**
     * ե᥽å
     *
     * @static
     * @access public
     * @param string ե४֥̾
     * @param string URL
     * @return object ե४֥
     */
    function &factory($classpath, $action='')
    {
        static $forms = array();
        if (!isset($forms[$classpath])) {
            $classname = class_exists($classpath) ? $classpath : SyL_Loader::convertClass($classpath, true);
            $forms[$classpath] = new $classname($action);
        }
        return $forms[$classpath];
    }

    /**
     * ǡ֥ȤΥХå᥽åɤϿ
     *
     * @access public
     * @param object ǡ֥
     */
    function registerInput(&$data)
    {
        // 
        $data->isGetArray(true);
        // ѥ᡼᥽åɥå
        $this->registerInputCallback(array(&$data, 'get'));
    }

    /**
     * Ǥ°ɲä
     *
     * @access public
     * @param string ̾
     * @param array °
     */
    function addConfig($name, $attributes)
    {
        $this->elements_config[$name] = $attributes;
    }

    /**
     * Ǥ°
     *
     * @access public
     * @param string ̾
     * @return array °
     */
    function getConfig($name)
    {
        return $this->elements_config[$name];
    }

    /**
     * եۤ
     *
     * @access public
     * @param bool ɽե饰
     */
    function build($init=false)
    {
        // Ͽ롼
        foreach ($this->elements_config as $name => $values) {
            // Ǻ
            $element =& $this->createElement($name, $values);
            // Ƚ
            if ($init && isset($values['default'])) {
                $element->setValue($values['default']);
            }
            // Хǡɲ
            if (isset($values['validate']) && (count($values['validate']) > 0)) {
                $this->setElementValidations($element, $values);
            }
            $this->addElement($element);
        }
    }

    /**
     * Ǥ
     *
     * @access public
     * @param string ̾
     * @param array °
     */
    function &createElement($name, $values)
    {
        $type         = $values['type'];
        $display_name = isset($values['name'])       ? $values['name']       : $name;
        $options      = isset($values['options'])    ? $values['options']    : array();
        $attributes   = isset($values['attributes']) ? $values['attributes'] : array();
        return parent::createElement($type, $name, $display_name, $options, $attributes);
    }

    /**
     * Ǥ˥Хǡ򥻥åȤ
     *
     * @access public
     * @param object ǥ֥
     * @param array °
     */
    function setElementValidations(&$element, $values)
    {
        // Хǡɲ
        $vs =& SyL_Validators::create();
        foreach ($values['validate'] as $v_name => $v_values) {
            $v_parameters = isset($v_values['parameters']) ? $v_values['parameters'] : array();
            $vs->add(SyL_Validator::create($v_name, $v_values['message'], $v_parameters));
        }
        $element->setValidators($vs);
    }

    /**
     * եǤǼ
     *
     * @access public
     * @return array եǤ
     */
    function &getResultArray()
    {
        $results =& parent::getResultArray();
        if (!$results['read_only']) {
            foreach (array_keys($results['elements']) as $name) {
                if (isset($this->elements_config[$name])) {
                    if (isset($this->elements_config[$name]['note']) && $this->elements_config[$name]['note']) {
                        $results['elements'][$name]['html'] .= sprintf('<br><span class="note">%s</span>', $this->elements_config[$name]['note']);
                    }
                }
            }
        }
        return $results;
    }
}

?>
