<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_TemplateSmarty.php,v 1.1 2008/06/20 17:41:54 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/** 
 * Smartyƥץ졼ȥ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_TemplateSmarty.php,v 1.1 2008/06/20 17:41:54 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_TemplateSmarty extends SyL_Template
{
    /**
     * Smartyǥ쥯ȥ
     *
     * @access private
     * @var string
     */
    var $smarty_dir = '';
    /**
     * ѥǥ쥯ȥ
     *
     * @access private
     * @var string
     */
    var $compile_dir = '';
    /**
     * ǥ쥯ȥ
     *
     * @access private
     * @var string
     */
    var $config_dir = '';
    /**
     * åǥ쥯ȥ
     *
     * @access private
     * @var string
     */
    var $cache_dir = '';
    /**
     * ѥID
     *
     * @access private
     * @var string
     */
    var $compile_id = '';

    /**
     * Smartyǥ쥯ȥ򥻥å
     *
     * @access public
     * @param string Smartyǥ쥯ȥ
     */
    function setSmartyDir($smarty_dir)
    {
        $this->smarty_dir = $smarty_dir;
    }

    /**
     * ѥǥ쥯ȥ򥻥å
     *
     * @access public
     * @param string ѥǥ쥯ȥ
     */
    function setCompileDir($compile_dir)
    {
        $this->compile_dir = $compile_dir;
    }

    /**
     * ǥ쥯ȥ򥻥å
     *
     * @access public
     * @param string ǥ쥯ȥ
     */
    function setConfigDir($config_dir)
    {
        $this->config_dir = $config_dir;
    }

    /**
     * åǥ쥯ȥ򥻥å
     *
     * @access public
     * @param string ǥ쥯ȥ
     */
    function setCacheDir($cache_dir)
    {
        $this->cache_dir = $cache_dir;
    }

    /**
     * ѥID򥻥å
     *
     * @access public
     * @param string ѥID
     */
    function setCompileId($compile_id)
    {
        $this->compile_id = $compile_id;
    }

    /**
     * ֥ƥץ졼ȤŬѤ
     *
     * @access public
     * @return array ƥץ졼ŬѸǡ
     */
    function renderChild()
    {
        foreach (array_keys($this->templates) as $name) {
            $this->templates[$name]->setSmartyDir($this->smarty_dir);
            $this->templates[$name]->setCompileDir($this->compile_dir);
            $this->templates[$name]->setConfigDir($this->config_dir);
            $this->templates[$name]->setCacheDir($this->cache_dir);
            $this->templates[$name]->setCompileId($this->compile_id);
        }
        return parent::renderChild();
    }

    /**
     * ƥץ졼ȤŬѤ
     *
     * @access public
     * @return string ƥץ졼ŬѸǡ
     */
    function render()
    {
        include_once $this->smarty_dir . 'Smarty.class.php';

        $smarty =& new Smarty();
        $smarty->compile_dir = $this->compile_dir;
        $smarty->config_dir  = $this->config_dir;
        $smarty->cache_dir   = $this->cache_dir;
        $smarty->compile_id  = $this->compile_id;

        $values = $this->gets();
        foreach (array_keys($values) as $key) {
            if (is_object($values[$key])) {
                $smarty->assign_by_ref($key, $values[$key]);
            } else {
                $smarty->assign($key, $values[$key]);
            }
        }

        // ֥ƥץ졼Ŭ
        foreach ($this->renderChild() as $key => $text) {
            $smarty->assign($key, $text);
        }

        return $smarty->fetch($this->template_file);
    }
}

?>
