<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceAuctionAuctionItemSearchRequest.php,v 1.1 2008/03/01 05:01:22 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹ʳŷ - ŷʸAPIѡ
 */
require_once 'SyL_WebServiceAuctionAuctionItemSearchResponse.php';

/**
 * WEBӥ饹ʳŷ - ŷʸAPIѡ
 *
 * ܺ٤ϡŷ֥ӥ󥿡
 *   http://webservice.rakuten.co.jp/
 * ŷʸAPI
 *   http://webservice.rakuten.co.jp/api/auctionitemsearch/
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceAuctionAuctionItemSearchRequest.php,v 1.1 2008/03/01 05:01:22 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceAuctionAuctionItemSearchRequest extends SyL_WebServiceRakuten_co_jpRequest
{
    /**
     * ¹URLѥ
     *
     * @access protected
     * @var string
     */
    var $path = '/rws/1.10/rest';
    /**
     * 쥹ݥ󥹥饹̾
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceAuctionAuctionItemSearchResponse';

    /**
     * ɤ򥻥åȤ
     *
     * @access public
     * @param string 
     */
    function setKeyword($keyword)
    {
        parent::set('keyword', $keyword);
    }

    /**
     * С򥻥åȤ
     *
     * @access public
     * @param string С
     */
    function setVersion($version)
    {
        parent::set('version', $version);
    }

    /**
     * ID򥻥åȤ
     *
     * @access public
     * @param int ID
     */
    function setGenreId($genreId)
    {
        if (preg_match('/^\d+$/', $genreId)) {
            parent::set('genreId', $genreId);
        } else {
            trigger_error("[SyL error] Invalid `genreId' property ({$genreId}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 1ڡμ򥻥åȤ
     *
     * @access public
     * @param int 1ڡμ
     */
    function setHits($hits)
    {
        if (preg_match('/^\d+$/', $hits) && (($hits >= 1) && ($hits <= 30))) {
            parent::set('hits', $hits);
        } else {
            trigger_error("[SyL error] Invalid `hits' property ({$hits}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ڡ򥻥åȤ
     *
     * @access public
     * @param int ڡ
     */
    function setPage($page)
    {
        if (preg_match('/^\d+$/', $page) && (($page >= 1) && ($page <= 100))) {
            parent::set('page', $page);
        } else {
            trigger_error("[SyL error] Invalid `page' property ({$page}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * Ǿʤ򥻥åȤ
     *
     * @access public
     * @param int Ǿ
     */
    function setMinPrice($minPrice)
    {
        if (preg_match('/^\d+$/', $minPrice)) {
            parent::set('minPrice', $minPrice);
        } else {
            trigger_error("[SyL error] Invalid `minPrice' property ({$minPrice}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ʤ򥻥åȤ
     *
     * @access public
     * @param int 
     */
    function setMaxPrice($maxPrice)
    {
        if (preg_match('/^\d+$/', $maxPrice)) {
            parent::set('maxPrice', $maxPrice);
        } else {
            trigger_error("[SyL error] Invalid `maxPrice' property ({$maxPrice}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * Ȥ򥻥åȤ
     *
     * @access public
     * @param string 
     */
    function setSort($sort)
    {
        switch ($sort) {
        case '+endTime':
        case '-endTime':
        case '+itemPrice':
        case '-itemPrice':
        case '+bidCount':
        case '-bidCount':
        case '+affiliateRate':
        case '-affiliateRate':
            parent::set('sort', $sort);
            break;
        default:
            trigger_error("[SyL error] Invalid `sort' property ({$sort}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ¨ե饰򥻥åȤ
     *
     * @access public
     * @param int ¨ե饰
     */
    function setBlowFlag($blowFlag)
    {
        switch ((string)$blowFlag) {
        case '0':
        case '1':
            parent::set('blowFlag', $blowFlag);
            break;
        default:
            trigger_error("[SyL error] Invalid `blowFlag' property ({$blowFlag}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * оݾʼ̥ե饰򥻥åȤ
     *
     * @access public
     * @param int оݾʼ̥ե饰
     */
    function setItemType($itemType)
    {
        switch ((string)$itemType) {
        case '0': // ٤Ƥξʤ򸡺оݤȤ
        case '1': // ĿͤνʾʤΤ߸оݤȤ
        case '2': // ŷԾŹޤνʾʤΤ߸оݤȤ
        case '3': // ڥȼԤνʾʤΤ߸оݤȤ
            parent::set('itemType', $itemType);
            break;
        default:
            trigger_error("[SyL error] Invalid `itemType' property ({$itemType}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ʾ֥ե饰򥻥åȤ
     *
     * @access public
     * @param int ʾ֥ե饰
     */
    function setNewFlag($newFlag)
    {
        switch ((string)$newFlag) {
        case '0': // ٤
        case '1': // ŤΤ
        case '2': // ʤΤ
            parent::set('newFlag', $newFlag);
            break;
        default:
            trigger_error("[SyL error] Invalid `newFlag' property ({$newFlag}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * եɤ򥻥åȤ
     *
     * @access public
     * @param int ե
     */
    function setField($field)
    {
        switch ((string)$field) {
        case '0':
        case '1':
            parent::set('field', $field);
            break;
        default:
            trigger_error("[SyL error] Invalid `field' property ({$field}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ꥢ򥻥åȤ
     *
     * @access public
     * @param int ꥢ
     */
    function setCarrier($carrier)
    {
        switch ((string)$carrier) {
        case '0':
        case '1':
            parent::set('carrier', $carrier);
            break;
        default:
            trigger_error("[SyL error] Invalid `carrier' property ({$carrier}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ʲ̵ͭե饰򥻥åȤ
     *
     * @access public
     * @param int ʲ̵ͭե饰
     */
    function setImageFlag($imageFlag)
    {
        switch ((string)$imageFlag) {
        case '0':
        case '1':
            parent::set('imageFlag', $imageFlag);
            break;
        default:
            trigger_error("[SyL error] Invalid `imageFlag' property ({$imageFlag}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ORե饰򥻥åȤ
     *
     * @access public
     * @param int ORե饰
     */
    function setOrFlag($orFlag)
    {
        switch ((string)$orFlag) {
        case '0':
        case '1':
            parent::set('orFlag', $orFlag);
            break;
        default:
            trigger_error("[SyL error] Invalid `orFlag' property ({$orFlag}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ɤ򥻥åȤ
     *
     * @access public
     * @param string 
     */
    function setNGKeyword($NGKeyword)
    {
        parent::set('NGKeyword', $NGKeyword);
    }

}

?>
