<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceTravelKeywordHotelSearchResponse.php,v 1.1 2008/03/01 05:01:22 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹ʳŷ - ŷȥ٥߸API ѡ
 *
 * ܺ٤ϡŷ֥ӥ󥿡
 *   http://webservice.rakuten.co.jp/
 * ŷȥ٥߸API  
 *   http://webservice.rakuten.co.jp/api/simplehotelsearch/
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceTravelKeywordHotelSearchResponse.php,v 1.1 2008/03/01 05:01:22 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceTravelKeywordHotelSearchResponse extends SyL_WebServiceRakuten_co_jpResponse
{
    /**
     * 쥳ɷ
     *
     * @access private
     * @var int
     */
    var $record_count = 0;
    /**
     * ߾
     *
     * @access private
     * @var array
     */
    var $hotel_simples = array();

    /**
     * XMLǡƼϥɥ᥽å
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i = -1;

        switch ($current_path) {
        // =============================
        // 
        // =============================
        // 쥳ɷʽߡ
        case '/Response/Body/keywordHotelSearch:KeywordHotelSearch/recordCount': $this->record_count = $text; break;
        
        case '/Response/Body/keywordHotelSearch:KeywordHotelSearch/hotelSimple': $i++; break;
        // ֹ
        case '/Response/Body/keywordHotelSearch:KeywordHotelSearch/hotelSimple/hotelNo': $this->hotel_simples[$i]['hotelNo'] = $text; break;
        // ̾
        case '/Response/Body/keywordHotelSearch:KeywordHotelSearch/hotelSimple/hotelName': $this->hotel_simples[$i]['hotelName'] = $text; break;
        // ϶
        case '/Response/Body/keywordHotelSearch:KeywordHotelSearch/hotelSimple/areaSum': $this->hotel_simples[$i]['areaSum'] = $text; break;
        // ÿ
        case '/Response/Body/keywordHotelSearch:KeywordHotelSearch/hotelSimple/hotelSpecialSum': $this->hotel_simples[$i]['hotelSpecialSum'] = $text; break;
        // ʬ
        case '/Response/Body/keywordHotelSearch:KeywordHotelSearch/hotelSimple/middleClassCode': $this->hotel_simples[$i]['middleClassCode'] = $text; break;
        // ʬ
        case '/Response/Body/keywordHotelSearch:KeywordHotelSearch/hotelSimple/smallClassCode': $this->hotel_simples[$i]['smallClassCode'] = $text; break;
        // ߾ڡURL
        case '/Response/Body/keywordHotelSearch:KeywordHotelSearch/hotelSimple/hotelInformationUrl': $this->hotel_simples[$i]['hotelInformationUrl'] = $text; break;
        // ߾ڡեꥨURL
        case '/Response/Body/keywordHotelSearch:KeywordHotelSearch/hotelSimple/hotelAffiliateUrl': $this->hotel_simples[$i]['hotelAffiliateUrl'] = $text; break;
        // οʥӥ塼ʿѡ
        case '/Response/Body/keywordHotelSearch:KeywordHotelSearch/hotelSimple/reviewAverage': $this->hotel_simples[$i]['reviewAverage'] = $text; break;
        // Ʒ
        case '/Response/Body/keywordHotelSearch:KeywordHotelSearch/hotelSimple/reviewCount': $this->hotel_simples[$i]['reviewCount'] = $text; break;

        // 嵭ʳ
        default: parent::getElement($current_path, $attribute, $text);
        }
    }

    /**
     * 쥳ɷ
     *
     * @access public
     * @return int 쥳ɷ
     */
    function getRecordCount()
    {
        return $this->record_count;
    }

    /**
     * ߾
     *
     * @access public
     * @return array ߾
     */
    function getHotelSimples()
    {
        return $this->hotel_simples;
    }
}

?>
